/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NestedIntegerValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack<String> defaultNamespaceStack = new Stack();
    private DateTimeValue currentDateTime = DateTimeValue.getCurrentDateTime(null);
    private Compilation compilation;
    private Stack<String> systemIdStack = new Stack();
    private Stack<URI> baseUriStack = new Stack();
    private NestedIntegerValue precedence;
    private int importCount = 0;
    private boolean dropUnderscoredAttributes;

    public UseWhenFilter(Compilation compilation, Receiver next, NestedIntegerValue precedence) {
        super(next);
        this.compilation = compilation;
        this.precedence = precedence;
    }

    public void setStartTagBuffer(StartTagBuffer startTag) {
        this.startTag = startTag;
    }

    public void open() throws XPathException {
        this.nextReceiver.open();
        try {
            String sysId = this.getSystemId();
            if (sysId == null) {
                sysId = "";
            }
            this.systemIdStack.push(sysId);
            this.baseUriStack.push(new URI(sysId));
        }
        catch (URISyntaxException e) {
            throw new XPathException("Invalid URI for stylesheet: " + this.getSystemId());
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        boolean inXsltNamespace = elemName.hasURI("http://www.w3.org/1999/XSL/Transform");
        String stdAttUri = inXsltNamespace ? "" : "http://www.w3.org/1999/XSL/Transform";
        this.defaultNamespaceStack.push(this.startTag.getAttribute(stdAttUri, "xpath-default-namespace"));
        if (this.emptyStylesheetElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            URI baseUri;
            block56: {
                boolean isStylesheetElement;
                String baseUriAtt;
                String systemId = location.getSystemId();
                if (systemId == null) {
                    systemId = this.getSystemId();
                }
                if ((baseUriAtt = this.startTag.getAttribute("http://www.w3.org/XML/1998/namespace", "base")) != null) {
                    if (systemId.equals(this.systemIdStack.peek())) {
                        baseUri = this.baseUriStack.peek().resolve(baseUriAtt);
                    } else {
                        try {
                            baseUri = new URI(systemId).resolve(baseUriAtt);
                        }
                        catch (URISyntaxException e) {
                            throw new XPathException("Invalid URI for stylesheet entity: " + systemId);
                        }
                    }
                } else if (systemId == null || systemId.equals(this.systemIdStack.peek())) {
                    baseUri = this.baseUriStack.peek();
                } else {
                    try {
                        baseUri = new URI(systemId);
                    }
                    catch (URISyntaxException e) {
                        throw new XPathException("Invalid URI for stylesheet entity: " + systemId);
                    }
                }
                this.baseUriStack.push(baseUri);
                this.systemIdStack.push(systemId);
                int cVersion = this.compilation.getProcessorVersion();
                if (inXsltNamespace && (cVersion == 0 || cVersion == 30)) {
                    AttributeCollection atts = this.startTag.getAllAttributes();
                    for (int a = 0; a < atts.getLength(); ++a) {
                        String local = atts.getLocalName(a);
                        if (!local.startsWith("_") || !atts.getURI(a).equals("") || local.length() < 2) continue;
                        if (cVersion == 0) {
                            cVersion = 30;
                            this.compilation.setProcessorVersion(cVersion);
                        }
                        String value = atts.getValue(a);
                        String newValue = this.processShadowAttribute(value, baseUri.toString(), location.getLineNumber());
                        String plainName = local.substring(1);
                        NoNamespaceName newName = new NoNamespaceName(plainName);
                        int index = atts.getIndex("", plainName);
                        if (index == -1) {
                            index = a;
                        }
                        ((AttributeCollectionImpl)atts).setAttribute(index, newName, BuiltInAtomicType.UNTYPED_ATOMIC, newValue, atts.getLocation(a), 0);
                    }
                }
                String useWhen = this.startTag.getAttribute(stdAttUri, "use-when");
                boolean bl = isStylesheetElement = inXsltNamespace && (elemName.getLocalPart().equals("stylesheet") || elemName.getLocalPart().equals("transform") || elemName.getLocalPart().equals("package"));
                if (this.compilation.getProcessorVersion() == 0) {
                    String version;
                    if (isStylesheetElement) {
                        version = this.startTag.getAttribute("", "version");
                        this.processVersionAttribute(version);
                    } else {
                        version = this.startTag.getAttribute("http://www.w3.org/1999/XSL/Transform", "version");
                        this.processVersionAttribute(version);
                    }
                }
                if (useWhen != null) {
                    try {
                        boolean use = this.evaluateUseWhen(useWhen, location, baseUri.toString());
                        if (use) break block56;
                        if (isStylesheetElement) {
                            this.emptyStylesheetElement = true;
                            break block56;
                        }
                        this.depthOfHole = 1;
                        return;
                    }
                    catch (XPathException e) {
                        XPathException err = this.createXPathException("Error in use-when expression. " + e.getMessage(), e.getErrorCodeLocalPart(), location);
                        err.setErrorCodeQName(e.getErrorCodeQName());
                        throw err;
                    }
                }
            }
            if (inXsltNamespace && this.compilation.getProcessorVersion() >= 30) {
                boolean isVariable = elemName.getLocalPart().equals("variable");
                boolean isParam = elemName.getLocalPart().equals("param");
                String staticStr = Whitespace.trim(this.startTag.getAttribute("", "static"));
                if ((isVariable || isParam) && this.defaultNamespaceStack.size() == 2 && "yes".equals(staticStr) || "true".equals(staticStr) || "1".equals(staticStr)) {
                    boolean isSupplied;
                    StructuredQName varName;
                    String nameStr = this.startTag.getAttribute("", "name");
                    String asStr = this.startTag.getAttribute("", "as");
                    String requiredStr = Whitespace.trim(this.startTag.getAttribute("", "required"));
                    boolean isRequired = "yes".equals(requiredStr) || "true".equals(requiredStr) || "1".equals(requiredStr);
                    UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
                    staticContext.setBaseURI(baseUri.toString());
                    SequenceType requiredType = SequenceType.ANY_SEQUENCE;
                    if (asStr != null) {
                        XPathParser parser = new XPathParser();
                        requiredType = parser.parseSequenceType(asStr, staticContext);
                    }
                    try {
                        varName = StructuredQName.fromLexicalQName(nameStr, false, true, this.startTag);
                    }
                    catch (XPathException err) {
                        throw this.createXPathException("Invalid variable name:" + nameStr + ". " + err.getMessage(), err.getErrorCodeLocalPart(), location);
                    }
                    boolean bl = isSupplied = isParam && this.compilation.getCompilerInfo().getParameters().containsKey(varName);
                    if (isParam) {
                        if (isRequired && !isSupplied) {
                            throw this.createXPathException("No value was supplied for the required static parameter $" + varName.getDisplayName(), "XTDE0050", location);
                        }
                        if (isSupplied) {
                            Sequence suppliedValue = this.compilation.getCompilerInfo().getParameters().convertParameterValue(varName, requiredType, true, staticContext.makeEarlyEvaluationContext());
                            this.compilation.declareStaticVariable(varName, SequenceTool.toGroundedValue(suppliedValue), this.precedence);
                        }
                    }
                    if (isVariable || !isSupplied) {
                        GroundedValue value;
                        String selectStr = this.startTag.getAttribute("", "select");
                        if (selectStr == null) {
                            if (isVariable) {
                                throw this.createXPathException("The select attribute is required for a static global variable", "XTSE0010", location);
                            }
                            value = asStr == null ? StringValue.EMPTY_STRING : EmptySequence.getInstance();
                            this.compilation.declareStaticVariable(varName, value, this.precedence);
                        } else {
                            try {
                                Sequence seq = this.evaluateStatic(selectStr, location, staticContext);
                                value = SequenceTool.toGroundedValue(seq);
                            }
                            catch (XPathException e) {
                                throw this.createXPathException("Error in " + elemName.getLocalPart() + " expression. " + e.getMessage(), e.getErrorCodeLocalPart(), location);
                            }
                        }
                        RoleDiagnostic role = new RoleDiagnostic(3, varName.getDisplayName(), 0);
                        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
                        Sequence seq = th.applyFunctionConversionRules(value, requiredType, role, location);
                        value = SequenceTool.toGroundedValue(seq);
                        try {
                            this.compilation.declareStaticVariable(varName, value, this.precedence);
                        }
                        catch (XPathException e) {
                            throw this.createXPathException(e.getMessage(), e.getErrorCodeLocalPart(), location);
                        }
                    }
                }
            }
            if (inXsltNamespace) {
                boolean isInclude = elemName.getLocalPart().equals("include");
                boolean isImport = elemName.getLocalPart().equals("import");
                if (isInclude || isImport) {
                    Map<DocumentURI, TreeInfo> map;
                    Source source;
                    String href = Whitespace.trim(this.startTag.getAttribute("", "href"));
                    if (href == null) {
                        throw new XPathException("Missing href attribute on " + elemName.getDisplayName(), "XTSE0010");
                    }
                    URIResolver resolver = this.compilation.getCompilerInfo().getURIResolver();
                    String baseUriStr = baseUri.toString();
                    DocumentURI key = DocumentFn.computeDocumentKey(href, baseUriStr, this.compilation.getPackageData(), resolver, false);
                    try {
                        source = resolver.resolve(href, baseUriStr);
                    }
                    catch (TransformerException e) {
                        throw XPathException.makeXPathException(e);
                    }
                    if (source == null) {
                        source = this.getConfiguration().getSystemURIResolver().resolve(href, baseUriStr);
                    }
                    if ((map = this.compilation.getStylesheetModules()).containsKey(key)) {
                        NodeInfo next;
                        DocumentImpl module = (DocumentImpl)map.get(key).getRootNode();
                        ElementImpl outer = module.getDocumentElement();
                        AxisIterator top = outer.iterateAxis((byte)3, NodeKindTest.ELEMENT);
                        while ((next = top.next()) != null) {
                            String staticStr = Whitespace.trim(next.getAttributeValue("", "static"));
                            if (next.getURI().equals("http://www.w3.org/1999/XSL/Transform") && (next.getLocalPart().equals("param") || next.getLocalPart().equals("variable")) && !"yes".equals(staticStr) && !"true".equals(staticStr) && !"1".equals(staticStr)) continue;
                        }
                    } else {
                        NestedIntegerValue newPrecedence = this.precedence;
                        if (isImport) {
                            newPrecedence = this.precedence.getStem().append(this.precedence.getLeaf() - 1).append(2 * ++this.importCount);
                        }
                        try {
                            DocumentImpl includedDoc = StylesheetModule.loadStylesheetModule(source, false, this.compilation, newPrecedence);
                            map.put(key, includedDoc);
                        }
                        catch (XPathException e) {
                            e.setLocation(location);
                            e.maybeSetErrorCode("XTSE0165");
                            if ("XTSE0180".equals(e.getErrorCodeLocalPart()) && isImport) {
                                e.setErrorCode("XTSE0210");
                            }
                            if (!e.hasBeenReported()) {
                                this.compilation.reportError(e);
                            }
                            throw e;
                        }
                    }
                }
                if (elemName.getLocalPart().equals("use-package") && this.precedence.getDepth() > 1) {
                    throw new XPathException("xsl:use-package cannot appear in an imported stylesheet", "XTSE3008");
                }
            }
            this.dropUnderscoredAttributes = inXsltNamespace;
            this.nextReceiver.startElement(elemName, typeCode, location, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    private void processVersionAttribute(String version) throws XPathException {
        if (version != null) {
            ConversionResult cr = DecimalValue.makeDecimalValue(version, true);
            if (cr instanceof ValidationFailure) {
                throw new XPathException("Invalid version number: " + version, "XTSE0110");
            }
            DecimalValue d = (DecimalValue)cr.asAtomic();
            int v = d.getDecimalValue().multiply(BigDecimal.TEN).intValue();
            this.compilation.setProcessorVersion(v);
        }
    }

    private String processShadowAttribute(String expression, String baseUri, int lineNumber) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
        staticContext.setBaseURI(baseUri);
        this.setNamespaceBindings(staticContext);
        Expression expr = AttributeValueTemplate.make(expression, staticContext);
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.allocateSlots(expression, expr);
        XPathContext dynamicContext = this.makeDynamicContext(staticContext);
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return expr.evaluateAsString(dynamicContext).toString();
    }

    public XPathException createXPathException(String message, String errorCode, Location location) throws XPathException {
        XPathException err = new XPathException(message);
        err.setErrorCode(errorCode);
        err.setIsStaticError(true);
        err.setLocator(location.saveLocation());
        this.getPipelineConfiguration().getErrorListener().fatalError(err);
        err.setHasBeenReported(true);
        return err;
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(namespaceBinding, properties);
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (!(this.depthOfHole != 0 || this.dropUnderscoredAttributes && attName.getLocalPart().startsWith("_") && attName.hasURI(""))) {
            this.nextReceiver.attribute(attName, typeCode, value, locationId, properties);
        }
    }

    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
        }
        this.dropUnderscoredAttributes = false;
    }

    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.systemIdStack.pop();
            this.baseUriStack.pop();
            this.nextReceiver.endElement();
        }
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) {
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
    }

    public boolean evaluateUseWhen(String expression, Location locationId, String baseUri) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
        staticContext.setBaseURI(baseUri);
        this.setNamespaceBindings(staticContext);
        Expression expr = ExpressionTool.make(expression, staticContext, 0, 0, null);
        expr.setRetainedStaticContext(staticContext.makeRetainedStaticContext());
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.allocateSlots(expression, expr);
        XPathContext dynamicContext = this.makeDynamicContext(staticContext);
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return expr.effectiveBooleanValue(dynamicContext);
    }

    private SlotManager allocateSlots(String expression, Expression expr) {
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        if (expression.indexOf(36) >= 0) {
            ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        }
        return stackFrameMap;
    }

    private void setNamespaceBindings(UseWhenStaticContext staticContext) {
        staticContext.setDefaultElementNamespace("");
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            String uri = (String)this.defaultNamespaceStack.get(i);
            if (uri == null) continue;
            staticContext.setDefaultElementNamespace(uri);
            break;
        }
    }

    private Expression typeCheck(Expression expr, UseWhenStaticContext staticContext) throws XPathException {
        ItemType contextItemType = Type.ITEM_TYPE;
        ContextItemStaticInfo cit = new ContextItemStaticInfo(contextItemType, true);
        ExpressionVisitor visitor = ExpressionVisitor.make(staticContext);
        return expr.typeCheck(visitor, cit);
    }

    private XPathContext makeDynamicContext(UseWhenStaticContext staticContext) throws XPathException {
        Controller controller = new Controller(this.getConfiguration());
        controller.getExecutable().setFunctionLibrary((FunctionLibraryList)staticContext.getFunctionLibrary());
        if (staticContext.getXPathVersion() < 30) {
            controller.setURIResolver(new URIPreventer());
        }
        controller.setCurrentDateTime(this.currentDateTime);
        XPathContextMajor dynamicContext = controller.newXPathContext();
        dynamicContext = dynamicContext.newCleanContext();
        return dynamicContext;
    }

    public Sequence evaluateStatic(String expression, Location locationId, UseWhenStaticContext staticContext) throws XPathException {
        this.setNamespaceBindings(staticContext);
        Expression expr = ExpressionTool.make(expression, staticContext, 0, 0, null);
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        XPathContext dynamicContext = this.makeDynamicContext(staticContext);
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return SequenceExtent.makeSequenceExtent(expr.iterate(dynamicContext));
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        public Source resolve(String href, String base) throws XPathException {
            throw new XPathException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

