/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.Nonnull;

public final class EnumerationFromIterator<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private final Iterator<ELEMENTTYPE> m_aIter;

    public EnumerationFromIterator(@Nonnull Iterable<ELEMENTTYPE> aCont) {
        this(aCont.iterator());
    }

    public EnumerationFromIterator(@Nonnull Iterator<ELEMENTTYPE> aIter) {
        if (aIter == null) {
            throw new NullPointerException("iterator");
        }
        this.m_aIter = aIter;
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_aIter.hasNext();
    }

    @Override
    public ELEMENTTYPE nextElement() {
        return this.m_aIter.next();
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter", this.m_aIter).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> EnumerationFromIterator<ELEMENTTYPE> create(@Nonnull Iterator<ELEMENTTYPE> aIter) {
        return new EnumerationFromIterator<ELEMENTTYPE>(aIter);
    }

    @Nonnull
    public static <ELEMENTTYPE> EnumerationFromIterator<ELEMENTTYPE> create(@Nonnull Iterable<ELEMENTTYPE> aCont) {
        return new EnumerationFromIterator<ELEMENTTYPE>(aCont);
    }
}

