/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.callback.INonThrowingRunnableWithParameter;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.streams.NonBlockingBufferedReader;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.mock.IMockException;
import com.phloc.commons.mutable.MutableLong;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.string.StringHelper;
import java.io.Closeable;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class StreamUtils {
    private static final int DEFAULT_BUFSIZE = 16384;
    private static final Logger s_aLogger = LoggerFactory.getLogger(StreamUtils.class);
    private static final IStatisticsHandlerSize s_aByteSizeHdl = StatisticsManager.getSizeHandler(StreamUtils.class.getName() + "$COPY");
    private static final IStatisticsHandlerSize s_aCharSizeHdl = StatisticsManager.getSizeHandler(StreamUtils.class.getName() + "$COPYCHARS");
    private static final StreamUtils s_aInstance = new StreamUtils();

    private StreamUtils() {
    }

    public static boolean isKnownEOFException(@Nullable Throwable t) {
        return t == null ? false : StreamUtils.isKnownEOFException(t.getClass());
    }

    public static boolean isKnownEOFException(@Nullable Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        String sClass = aClass.getName();
        return sClass.equals("java.io.EOFException") || sClass.equals("org.mortbay.jetty.EofException") || sClass.equals("org.eclipse.jetty.io.EofException") || sClass.equals("org.apache.catalina.connector.ClientAbortException");
    }

    @Nonnull
    public static ESuccess closeWithoutFlush(@Nullable @WillClose Closeable aCloseable) {
        block3: {
            if (aCloseable != null) {
                try {
                    aCloseable.close();
                    return ESuccess.SUCCESS;
                }
                catch (IOException ex) {
                    if (StreamUtils.isKnownEOFException(ex)) break block3;
                    s_aLogger.error("Failed to close stream " + aCloseable.getClass().getName(), (Throwable)(ex instanceof IMockException ? null : ex));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose Closeable aCloseable) {
        block5: {
            if (aCloseable != null) {
                try {
                    if (aCloseable instanceof Flushable) {
                        StreamUtils.flush((Flushable)((Object)aCloseable));
                    }
                    aCloseable.close();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException ex) {
                }
                catch (IOException ex) {
                    if (StreamUtils.isKnownEOFException(ex)) break block5;
                    s_aLogger.error("Failed to close object " + aCloseable.getClass().getName(), (Throwable)(ex instanceof IMockException ? null : ex));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess flush(@Nullable Flushable aFlushable) {
        block4: {
            if (aFlushable != null) {
                try {
                    aFlushable.flush();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException ex) {
                }
                catch (IOException ex) {
                    if (StreamUtils.isKnownEOFException(ex)) break block4;
                    s_aLogger.error("Failed to flush object " + aFlushable.getClass().getName(), (Throwable)(ex instanceof IMockException ? null : ex));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamAndCloseOS(@WillClose @Nullable InputStream aIS, @WillClose @Nullable OutputStream aOS) {
        try {
            ESuccess eSuccess = StreamUtils.copyInputStreamToOutputStream(aIS, aOS, new byte[16384], null, null);
            return eSuccess;
        }
        finally {
            StreamUtils.close(aOS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamWithLimitAndCloseOS(@WillClose @Nullable InputStream aIS, @WillClose @Nullable OutputStream aOS, @Nonnegative long nLimit) {
        try {
            ESuccess eSuccess = StreamUtils.copyInputStreamToOutputStream(aIS, aOS, new byte[16384], null, nLimit);
            return eSuccess;
        }
        finally {
            StreamUtils.close(aOS);
        }
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream aIS, @WillNotClose @Nullable OutputStream aOS) {
        return StreamUtils.copyInputStreamToOutputStream(aIS, aOS, new byte[16384], null, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream aIS, @WillNotClose @Nullable OutputStream aOS, @Nullable MutableLong aCopyByteCount) {
        return StreamUtils.copyInputStreamToOutputStream(aIS, aOS, new byte[16384], aCopyByteCount, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamWithLimit(@WillClose @Nullable InputStream aIS, @WillNotClose @Nullable OutputStream aOS, @Nonnegative long nLimit) {
        return StreamUtils.copyInputStreamToOutputStream(aIS, aOS, new byte[16384], null, nLimit);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream aIS, @WillNotClose @Nullable OutputStream aOS, @Nonnull byte[] aBuffer) {
        return StreamUtils.copyInputStreamToOutputStream(aIS, aOS, aBuffer, null, null);
    }

    @Nonnegative
    private static long _copyInputStreamToOutputStream(@Nonnull InputStream aIS, @Nonnull OutputStream aOS, @Nonnull byte[] aBuffer) throws IOException {
        int nBytesRead;
        long nTotalBytesWritten = 0L;
        while ((nBytesRead = aIS.read(aBuffer, 0, aBuffer.length)) > -1) {
            aOS.write(aBuffer, 0, nBytesRead);
            nTotalBytesWritten += (long)nBytesRead;
        }
        return nTotalBytesWritten;
    }

    @Nonnegative
    private static long _copyInputStreamToOutputStreamWithLimit(@Nonnull InputStream aIS, @Nonnull OutputStream aOS, @Nonnull byte[] aBuffer, @Nonnegative long nLimit) throws IOException {
        long nRest = nLimit;
        long nTotalBytesWritten = 0L;
        while (true) {
            int nBytesRead;
            int nBytesToRead;
            int n = nBytesToRead = nRest >= (long)aBuffer.length ? aBuffer.length : (int)nRest;
            if (nBytesToRead == 0 || (nBytesRead = aIS.read(aBuffer, 0, nBytesToRead)) == -1) break;
            if (nBytesRead <= 0) continue;
            aOS.write(aBuffer, 0, nBytesRead);
            nTotalBytesWritten += (long)nBytesRead;
            nRest -= (long)nBytesRead;
        }
        return nTotalBytesWritten;
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream aIS, @WillNotClose @Nullable OutputStream aOS, @Nonnull @Nonempty byte[] aBuffer, @Nullable MutableLong aCopyByteCount) {
        return StreamUtils.copyInputStreamToOutputStream(aIS, aOS, aBuffer, aCopyByteCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream aIS, @WillNotClose @Nullable OutputStream aOS, @Nonnull @Nonempty byte[] aBuffer, @Nullable MutableLong aCopyByteCount, @Nullable Long aLimit) {
        if (ArrayHelper.isEmpty(aBuffer)) {
            throw new IllegalArgumentException("buffer is empty");
        }
        if (aLimit != null && aLimit < 0L) {
            throw new IllegalArgumentException("Limit may not be negative!");
        }
        try {
            if (aIS != null && aOS != null) {
                long nTotalBytesCopied = aLimit == null ? StreamUtils._copyInputStreamToOutputStream(aIS, aOS, aBuffer) : StreamUtils._copyInputStreamToOutputStreamWithLimit(aIS, aOS, aBuffer, aLimit);
                s_aByteSizeHdl.addSize(nTotalBytesCopied);
                if (aCopyByteCount != null) {
                    aCopyByteCount.set(nTotalBytesCopied);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (IOException ex) {
            if (!StreamUtils.isKnownEOFException(ex)) {
                s_aLogger.error("Failed to copy from stream to stream", (Throwable)(ex instanceof IMockException ? null : ex));
            }
        }
        finally {
            StreamUtils.close(aIS);
        }
        return ESuccess.FAILURE;
    }

    public static int getAvailable(@Nullable InputStream aIS) {
        if (aIS != null) {
            try {
                return aIS.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Nonnull
    public static NonBlockingByteArrayOutputStream getCopy(@Nonnull @WillClose InputStream aIS) {
        int nAvailable = Math.max(16384, StreamUtils.getAvailable(aIS));
        NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream(nAvailable);
        StreamUtils.copyInputStreamToOutputStreamAndCloseOS(aIS, aBAOS);
        return aBAOS;
    }

    @Nonnull
    public static NonBlockingByteArrayOutputStream getCopyWithLimit(@Nonnull @WillClose InputStream aIS, @Nonnegative long nLimit) {
        int nAvailable = Math.max(16384, StreamUtils.getAvailable(aIS));
        NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream(nAvailable);
        StreamUtils.copyInputStreamToOutputStreamWithLimitAndCloseOS(aIS, aBAOS, nLimit);
        return aBAOS;
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable IInputStreamProvider aISP) {
        if (aISP == null) {
            return null;
        }
        return StreamUtils.getAllBytes(aISP.getInputStream());
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable @WillClose InputStream aIS) {
        if (aIS == null) {
            return null;
        }
        return StreamUtils.getCopy(aIS).toByteArray();
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable IInputStreamProvider aISP, @Nonnull @Nonempty String sCharset) {
        if (aISP == null) {
            return null;
        }
        return StreamUtils.getAllBytesAsString(aISP.getInputStream(), sCharset);
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable IInputStreamProvider aISP, @Nonnull @Nonempty Charset aCharset) {
        if (aISP == null) {
            return null;
        }
        return StreamUtils.getAllBytesAsString(aISP.getInputStream(), aCharset);
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable @WillClose InputStream aIS, @Nonnull @Nonempty String sCharset) {
        if (StringHelper.hasNoText(sCharset)) {
            throw new IllegalArgumentException("empty charset");
        }
        if (aIS == null) {
            return null;
        }
        return StreamUtils.getCopy(aIS).getAsString(sCharset);
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable @WillClose InputStream aIS, @Nonnull @Nonempty Charset aCharset) {
        if (aCharset == null) {
            throw new NullPointerException("empty charset");
        }
        if (aIS == null) {
            return null;
        }
        return StreamUtils.getCopy(aIS).getAsString(aCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyReaderToWriterAndCloseWriter(@WillClose @Nullable Reader aReader, @WillClose @Nullable Writer aWriter) {
        try {
            ESuccess eSuccess = StreamUtils.copyReaderToWriter(aReader, aWriter, new char[16384], null, null);
            return eSuccess;
        }
        finally {
            StreamUtils.close(aWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyReaderToWriterWithLimitAndCloseWriter(@WillClose @Nullable Reader aReader, @WillClose @Nullable Writer aWriter, @Nonnegative long nLimit) {
        try {
            ESuccess eSuccess = StreamUtils.copyReaderToWriter(aReader, aWriter, new char[16384], null, nLimit);
            return eSuccess;
        }
        finally {
            StreamUtils.close(aWriter);
        }
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader aReader, @WillNotClose @Nullable Writer aWriter) {
        return StreamUtils.copyReaderToWriter(aReader, aWriter, new char[16384], null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader aReader, @WillNotClose @Nullable Writer aWriter, @Nullable MutableLong aCopyCharCount) {
        return StreamUtils.copyReaderToWriter(aReader, aWriter, new char[16384], aCopyCharCount, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader aReader, @WillNotClose @Nullable Writer aWriter, @Nonnull char[] aBuffer) {
        return StreamUtils.copyReaderToWriter(aReader, aWriter, aBuffer, null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriterWithLimit(@WillClose @Nullable Reader aReader, @WillNotClose @Nullable Writer aWriter, long nLimit) {
        return StreamUtils.copyReaderToWriter(aReader, aWriter, new char[16384], null, nLimit);
    }

    @Nonnegative
    private static long _copyReaderToWriter(@Nonnull Reader aReader, @Nonnull Writer aWriter, @Nonnull char[] aBuffer) throws IOException {
        int nCharsRead;
        long nTotalCharsWritten = 0L;
        while ((nCharsRead = aReader.read(aBuffer, 0, aBuffer.length)) > -1) {
            aWriter.write(aBuffer, 0, nCharsRead);
            nTotalCharsWritten += (long)nCharsRead;
        }
        return nTotalCharsWritten;
    }

    @Nonnegative
    private static long _copyReaderToWriterWithLimit(@Nonnull Reader aReader, @Nonnull Writer aWriter, @Nonnull char[] aBuffer, @Nonnegative long nLimit) throws IOException {
        long nRest = nLimit;
        long nTotalCharsWritten = 0L;
        while (true) {
            int nCharsRead;
            int nCharsToRead;
            int n = nCharsToRead = nRest >= (long)aBuffer.length ? aBuffer.length : (int)nRest;
            if (nCharsToRead == 0 || (nCharsRead = aReader.read(aBuffer, 0, nCharsToRead)) == -1) break;
            if (nCharsRead <= 0) continue;
            aWriter.write(aBuffer, 0, nCharsRead);
            nTotalCharsWritten += (long)nCharsRead;
            nRest -= (long)nCharsRead;
        }
        return nTotalCharsWritten;
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader aReader, @WillNotClose @Nullable Writer aWriter, @Nonnull @Nonempty char[] aBuffer, @Nullable MutableLong aCopyCharCount) {
        return StreamUtils.copyReaderToWriter(aReader, aWriter, aBuffer, aCopyCharCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader aReader, @WillNotClose @Nullable Writer aWriter, @Nonnull @Nonempty char[] aBuffer, @Nullable MutableLong aCopyCharCount, @Nullable Long aLimit) {
        if (ArrayHelper.isEmpty(aBuffer)) {
            throw new IllegalArgumentException("buffer is empty");
        }
        if (aLimit != null && aLimit < 0L) {
            throw new IllegalArgumentException("Limit may not be negative!");
        }
        try {
            if (aReader != null && aWriter != null) {
                long nTotalCharsCopied = aLimit == null ? StreamUtils._copyReaderToWriter(aReader, aWriter, aBuffer) : StreamUtils._copyReaderToWriterWithLimit(aReader, aWriter, aBuffer, aLimit);
                s_aCharSizeHdl.addSize(nTotalCharsCopied);
                if (aCopyCharCount != null) {
                    aCopyCharCount.set(nTotalCharsCopied);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (IOException ex) {
            if (!StreamUtils.isKnownEOFException(ex)) {
                s_aLogger.error("Failed to copy from reader to writer", (Throwable)(ex instanceof IMockException ? null : ex));
            }
        }
        finally {
            StreamUtils.close(aReader);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static NonBlockingStringWriter getCopy(@Nonnull @WillClose Reader aReader) {
        NonBlockingStringWriter aWriter = new NonBlockingStringWriter(16384);
        StreamUtils.copyReaderToWriterAndCloseWriter(aReader, aWriter);
        return aWriter;
    }

    @Nonnull
    public static NonBlockingStringWriter getCopyWithLimit(@Nonnull @WillClose Reader aReader, @Nonnegative long nLimit) {
        NonBlockingStringWriter aWriter = new NonBlockingStringWriter(16384);
        StreamUtils.copyReaderToWriterWithLimitAndCloseWriter(aReader, aWriter, nLimit);
        return aWriter;
    }

    @Nullable
    public static char[] getAllCharacters(@Nullable @WillClose Reader aReader) {
        if (aReader == null) {
            return null;
        }
        return StreamUtils.getCopy(aReader).getAsCharArray();
    }

    @Nullable
    public static String getAllCharactersAsString(@Nullable @WillClose Reader aReader) {
        if (aReader == null) {
            return null;
        }
        return StreamUtils.getCopy(aReader).getAsString();
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IInputStreamProvider aISP, @Nonnull @Nonempty String sCharset) {
        return StreamUtils.readStreamLines(aISP, sCharset, 0, -1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IInputStreamProvider aISP, @Nonnull Charset aCharset) {
        return StreamUtils.readStreamLines(aISP, aCharset, 0, -1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IInputStreamProvider aISP, @Nonnull @Nonempty String sCharset, @Nonnegative int nLinesToSkip, int nLinesToRead) {
        if (aISP == null) {
            return null;
        }
        return StreamUtils.readStreamLines(aISP.getInputStream(), sCharset, nLinesToSkip, nLinesToRead);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnegative int nLinesToSkip, int nLinesToRead) {
        if (aISP == null) {
            return null;
        }
        return StreamUtils.readStreamLines(aISP.getInputStream(), aCharset, nLinesToSkip, nLinesToRead);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull @Nonempty String sCharset) {
        return StreamUtils.readStreamLines(aIS, sCharset, 0, -1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull @Nonempty Charset aCharset) {
        return StreamUtils.readStreamLines(aIS, aCharset, 0, -1);
    }

    public static void readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull @Nonempty String sCharset, final @Nonnull List<String> aTargetList) {
        if (aIS != null) {
            StreamUtils.readStreamLines(aIS, sCharset, 0, -1, new INonThrowingRunnableWithParameter<String>(){

                @Override
                public void run(String sLine) {
                    aTargetList.add(sLine);
                }
            });
        }
    }

    public static void readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull Charset aCharset, final @Nonnull List<String> aTargetList) {
        if (aIS != null) {
            StreamUtils.readStreamLines(aIS, aCharset, 0, -1, new INonThrowingRunnableWithParameter<String>(){

                @Override
                public void run(String sLine) {
                    aTargetList.add(sLine);
                }
            });
        }
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull @Nonempty String sCharset, @Nonnegative int nLinesToSkip, int nLinesToRead) {
        if (aIS == null) {
            return null;
        }
        final ArrayList<String> ret = new ArrayList<String>();
        StreamUtils.readStreamLines(aIS, sCharset, nLinesToSkip, nLinesToRead, new INonThrowingRunnableWithParameter<String>(){

            @Override
            public void run(String sLine) {
                ret.add(sLine);
            }
        });
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull Charset aCharset, @Nonnegative int nLinesToSkip, int nLinesToRead) {
        if (aIS == null) {
            return null;
        }
        final ArrayList<String> ret = new ArrayList<String>();
        StreamUtils.readStreamLines(aIS, aCharset, nLinesToSkip, nLinesToRead, new INonThrowingRunnableWithParameter<String>(){

            @Override
            public void run(String sLine) {
                ret.add(sLine);
            }
        });
        return ret;
    }

    public static void readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull @Nonempty String sCharset, @Nonnull INonThrowingRunnableWithParameter<String> aLineCallback) {
        StreamUtils.readStreamLines(aIS, sCharset, 0, -1, aLineCallback);
    }

    public static void readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull @Nonempty Charset aCharset, @Nonnull INonThrowingRunnableWithParameter<String> aLineCallback) {
        StreamUtils.readStreamLines(aIS, aCharset, 0, -1, aLineCallback);
    }

    private static void _readFromReader(int nLinesToSkip, int nLinesToRead, INonThrowingRunnableWithParameter<String> aLineCallback, boolean bReadAllLines, NonBlockingBufferedReader aBR) throws IOException {
        String sLine;
        for (int i = 0; i < nLinesToSkip && (sLine = aBR.readLine()) != null; ++i) {
        }
        if (bReadAllLines) {
            while ((sLine = aBR.readLine()) != null) {
                aLineCallback.run(sLine);
            }
        } else {
            int nRead = 0;
            while ((sLine = aBR.readLine()) != null) {
                aLineCallback.run(sLine);
                if (++nRead < nLinesToRead) continue;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull @Nonempty Charset aCharset, @Nonnegative int nLinesToSkip, int nLinesToRead, @Nonnull INonThrowingRunnableWithParameter<String> aLineCallback) {
        block12: {
            boolean bReadAllLines;
            if (aCharset == null) {
                throw new NullPointerException("Empty charset passed!");
            }
            if (nLinesToSkip < 0) {
                throw new IllegalArgumentException("First line may not be negative: " + nLinesToSkip);
            }
            boolean bl = bReadAllLines = nLinesToRead == -1;
            if (nLinesToRead < 0 && !bReadAllLines) {
                throw new IllegalArgumentException("Line count may not be that negative: " + nLinesToRead);
            }
            if (aLineCallback == null) {
                throw new NullPointerException("lineCallback");
            }
            if (aIS != null) {
                try {
                    if (!bReadAllLines && nLinesToRead <= 0) break block12;
                    NonBlockingBufferedReader aBR = null;
                    try {
                        aBR = new NonBlockingBufferedReader(StreamUtils.createReader(aIS, aCharset));
                        StreamUtils._readFromReader(nLinesToSkip, nLinesToRead, aLineCallback, bReadAllLines, aBR);
                    }
                    catch (IOException ex) {
                        try {
                            s_aLogger.error("Failed to read from input stream", (Throwable)(ex instanceof IMockException ? null : ex));
                        }
                        catch (Throwable throwable) {
                            StreamUtils.close(aBR);
                            throw throwable;
                        }
                        StreamUtils.close(aBR);
                        break block12;
                    }
                    StreamUtils.close(aBR);
                }
                finally {
                    StreamUtils.close(aIS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readStreamLines(@WillClose @Nullable InputStream aIS, @Nonnull @Nonempty String sCharset, @Nonnegative int nLinesToSkip, int nLinesToRead, @Nonnull INonThrowingRunnableWithParameter<String> aLineCallback) {
        block12: {
            boolean bReadAllLines;
            if (StringHelper.hasNoText(sCharset)) {
                throw new IllegalArgumentException("Empty charset passed!");
            }
            if (nLinesToSkip < 0) {
                throw new IllegalArgumentException("First line may not be negative: " + nLinesToSkip);
            }
            boolean bl = bReadAllLines = nLinesToRead == -1;
            if (nLinesToRead < 0 && !bReadAllLines) {
                throw new IllegalArgumentException("Line count may not be that negative: " + nLinesToRead);
            }
            if (aLineCallback == null) {
                throw new NullPointerException("lineCallback");
            }
            if (aIS != null) {
                try {
                    if (!bReadAllLines && nLinesToRead <= 0) break block12;
                    NonBlockingBufferedReader aBR = null;
                    try {
                        aBR = new NonBlockingBufferedReader(StreamUtils.createReader(aIS, sCharset));
                        StreamUtils._readFromReader(nLinesToSkip, nLinesToRead, aLineCallback, bReadAllLines, aBR);
                    }
                    catch (IOException ex) {
                        try {
                            s_aLogger.error("Failed to read from input stream", (Throwable)(ex instanceof IMockException ? null : ex));
                        }
                        catch (Throwable throwable) {
                            StreamUtils.close(aBR);
                            throw throwable;
                        }
                        StreamUtils.close(aBR);
                        break block12;
                    }
                    StreamUtils.close(aBR);
                }
                finally {
                    StreamUtils.close(aIS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream aOS, @Nonnull byte[] aBuf, @Nonnegative int nOfs, @Nonnegative int nLen) {
        if (aOS == null) {
            throw new NullPointerException("outputStream");
        }
        if (aBuf == null) {
            throw new NullPointerException("content");
        }
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aBuf.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aBuf.length);
        }
        try {
            aOS.write(aBuf, nOfs, nLen);
            aOS.flush();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException ex) {
            s_aLogger.error("Failed to write to output stream", (Throwable)(ex instanceof IMockException ? null : ex));
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamUtils.close(aOS);
        }
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream aOS, @Nonnull byte[] aBuf) {
        return StreamUtils.writeStream(aOS, aBuf, 0, aBuf.length);
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream aOS, @Nonnull String sContent, @Nonnull String sCharset) {
        if (sContent == null) {
            throw new NullPointerException("content");
        }
        if (sCharset == null) {
            throw new NullPointerException("charset");
        }
        return StreamUtils.writeStream(aOS, CharsetManager.getAsBytes(sContent, sCharset));
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream aOS, @Nonnull String sContent, @Nonnull Charset aCharset) {
        if (sContent == null) {
            throw new NullPointerException("content");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        return StreamUtils.writeStream(aOS, CharsetManager.getAsBytes(sContent, aCharset));
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull String sText) {
        return new NonBlockingStringReader(sText);
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull char[] aChars) {
        return new NonBlockingStringReader(aChars);
    }

    @Nullable
    public static InputStreamReader createReader(@Nullable InputStream aIS, @Nonnull String sCharset) {
        try {
            return aIS == null ? null : new InputStreamReader(aIS, sCharset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Failed to create Reader for charset '" + sCharset + "'", ex);
        }
    }

    @Nullable
    public static InputStreamReader createReader(@Nullable InputStream aIS, @Nonnull Charset aCharset) {
        return aIS == null ? null : new InputStreamReader(aIS, aCharset);
    }

    @Nullable
    public static OutputStreamWriter createWriter(@Nullable OutputStream aOS, @Nonnull String sCharset) {
        try {
            return aOS == null ? null : new OutputStreamWriter(aOS, sCharset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Failed to create Writer for charset '" + sCharset + "'", ex);
        }
    }

    @Nullable
    public static OutputStreamWriter createWriter(@Nullable OutputStream aOS, @Nonnull Charset aCharset) {
        return aOS == null ? null : new OutputStreamWriter(aOS, aCharset);
    }

    public static void skipFully(@Nonnull InputStream aIS, @Nonnegative long nBytesToSkip) throws IOException {
        if (aIS == null) {
            throw new NullPointerException("InputStream");
        }
        if (nBytesToSkip < 0L) {
            throw new IllegalArgumentException("Cannot skip " + nBytesToSkip + " bytes. Only forward skip is possible!");
        }
        long nRemaining = nBytesToSkip;
        while (nRemaining > 0L) {
            long nSkipped = aIS.skip(nRemaining);
            if (nSkipped == 0L) {
                if (aIS.read() == -1) {
                    throw new EOFException("Failed to skip a total of " + nBytesToSkip + " bytes on input stream. Only skipped " + (nBytesToSkip - nRemaining) + " bytes so far!");
                }
                --nRemaining;
                continue;
            }
            nRemaining -= nSkipped;
        }
    }

    public static void readFully(@Nonnull InputStream aIS, @Nonnull byte[] aBuffer) throws IOException {
        StreamUtils.readFully(aIS, aBuffer, 0, aBuffer.length);
    }

    public static void readFully(@Nonnull InputStream aIS, @Nonnull byte[] aBuffer, @Nonnegative int nOfs, @Nonnegative int nLen) throws IOException {
        int nBytesRead;
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aBuffer.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aBuffer.length);
        }
        for (int nTotalBytesRead = 0; nTotalBytesRead < nLen; nTotalBytesRead += nBytesRead) {
            nBytesRead = aIS.read(aBuffer, nOfs + nTotalBytesRead, nLen - nTotalBytesRead);
            if (nBytesRead >= 0) continue;
            throw new EOFException("Failed to read a total of " + nLen + " bytes from input stream. Only read " + nTotalBytesRead + " bytes so far.");
        }
    }
}

