/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.resource;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.text.resource.XMLResourceBundle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

public final class XMLResourceBundleControl
extends ResourceBundle.Control {
    private static final String FORMAT_XML = "xml";
    private static final List<String> FORMATS = ContainerHelper.newUnmodifiableList("xml");

    @Override
    public List<String> getFormats(@Nonnull String sBaseName) {
        if (sBaseName == null) {
            throw new NullPointerException("baseName");
        }
        return FORMATS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(@Nonnull String sBaseName, @Nonnull Locale aLocale, @Nonnull String sFormat, @Nonnull ClassLoader aClassLoader, boolean bReload) throws IOException {
        URLConnection aURLConnection;
        String sBundleName;
        String sResourceName;
        URL aResourceUrl;
        if (sBaseName == null) {
            throw new NullPointerException("baseName");
        }
        if (aLocale == null) {
            throw new NullPointerException("locale");
        }
        if (sFormat == null) {
            throw new NullPointerException("format");
        }
        if (aClassLoader == null) {
            throw new NullPointerException("classLoader");
        }
        if (sFormat.equals(FORMAT_XML) && (aResourceUrl = aClassLoader.getResource(sResourceName = this.toResourceName(sBundleName = this.toBundleName(sBaseName, aLocale), sFormat))) != null && (aURLConnection = aResourceUrl.openConnection()) != null) {
            InputStream aIS;
            if (bReload) {
                aURLConnection.setUseCaches(false);
            }
            if ((aIS = aURLConnection.getInputStream()) != null) {
                try {
                    XMLResourceBundle xMLResourceBundle;
                    BufferedInputStream aBufferedIS = new BufferedInputStream(aIS);
                    try {
                        xMLResourceBundle = new XMLResourceBundle(aBufferedIS);
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close(aBufferedIS);
                        throw throwable;
                    }
                    StreamUtils.close(aBufferedIS);
                    return xMLResourceBundle;
                }
                finally {
                    StreamUtils.close(aIS);
                }
            }
        }
        return null;
    }
}

