/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.ccpp;

import org.w3c.jigsaw.ccpp.CCPP;
import org.w3c.jigsaw.ccpp.CCPPWarning;
import org.w3c.jigsaw.ccpp.ProfileRef;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.www.http.HttpExt;
import org.w3c.www.http.HttpExtList;
import org.w3c.www.http.HttpFactory;

public class CCPPRequest
implements CCPP {
    Request request = null;
    ProfileRef[] references = null;
    HttpExtList httpextlist = null;

    public Request getHTTPRequest() {
        return this.request;
    }

    public static String getStandardWarning(int n) {
        int n2 = n / 100;
        int n3 = n % 100;
        switch (n2) {
            case 1: {
                if (n3 < 0 || n3 >= CCPP.msg_100.length) break;
                return CCPP.msg_100[n3];
            }
            case 2: {
                if (n3 < 0 || n3 >= CCPP.msg_200.length) break;
                return CCPP.msg_200[n3];
            }
        }
        return "Unknonwn Warning";
    }

    public String getCCPPHeaderValue(String string) {
        return this.request.getExtHeader("http://www.w3.org/1999/06/24-CCPPexchange", string);
    }

    public String getProfileDiff(int n) {
        String string = "Profile-Diff-" + n;
        return this.getCCPPHeaderValue(string);
    }

    public ProfileRef[] getProfileReferences() {
        if (this.references == null) {
            String string = this.getCCPPHeaderValue("Profile");
            if (string != null) {
                String[] stringArray = (String[])HttpFactory.parseTokenList(string).getValue();
                this.references = new ProfileRef[stringArray.length];
                for (int i = 0; i < this.references.length; ++i) {
                    this.references[i] = new ProfileRef(stringArray[i]);
                }
            } else {
                return null;
            }
        }
        return this.references;
    }

    public static CCPPRequest getCCPPRequest(Request request) {
        if (request.hasState("org.w3c.jigsaw.ccpp.ccpprequest")) {
            return (CCPPRequest)request.getState("org.w3c.jigsaw.ccpp.ccpprequest");
        }
        CCPPRequest cCPPRequest = new CCPPRequest(request);
        request.setState("org.w3c.jigsaw.ccpp.ccpprequest", cCPPRequest);
        return cCPPRequest;
    }

    protected Reply acknowledge(Reply reply) {
        HttpExtList httpExtList;
        HttpExtList httpExtList2 = this.request.getHttpManExtDecl();
        if (httpExtList2 != null && httpExtList2.getLength() == 1 && httpExtList2.getHttpExt("http://www.w3.org/1999/06/24-CCPPexchange") != null) {
            reply.setEnd2EndExtensionAcknowledgmentHeader();
        }
        if ((httpExtList = this.request.getHttpCManExtDecl()) != null && httpExtList.getLength() == 1 && httpExtList.getHttpExt("http://www.w3.org/1999/06/24-CCPPexchange") != null) {
            reply.setHopByHopExtensionAcknowledgmentHeader();
        }
        return reply;
    }

    public void addWarning(Reply reply, int n, String string) {
        CCPPWarning cCPPWarning = (CCPPWarning)reply.getState("org.w3c.jigsaw.ccpp.ccppwarning");
        if (cCPPWarning == null) {
            cCPPWarning = new CCPPWarning();
            reply.setState("org.w3c.jigsaw.ccpp.ccppwarning", cCPPWarning);
        }
        cCPPWarning.addWarning(n, string);
        HttpExtList httpExtList = reply.getExtList("http://www.w3.org/1999/06/24-CCPPexchange");
        if (httpExtList == null) {
            httpExtList = new HttpExtList(this.httpextlist);
            reply.setHttpExtDecl(httpExtList);
        }
        HttpExt httpExt = httpExtList.getHttpExt("http://www.w3.org/1999/06/24-CCPPexchange");
        reply.setExtensionHeader(httpExt, "Profile-Warning", cCPPWarning.toString());
    }

    private CCPPRequest(Request request) {
        this.request = request;
        this.httpextlist = request.getExtList("http://www.w3.org/1999/06/24-CCPPexchange");
    }
}

