/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.webdav.xml;

import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DAVNode {
    public static final String ACTIVELOCK_NODE = "activelock";
    public static final String LOCKSCOPE_NODE = "lockscope";
    public static final String LOCKTYPE_NODE = "locktype";
    public static final String DEPTH_NODE = "depth";
    public static final String OWNER_NODE = "owner";
    public static final String TIMEOUT_NODE = "timeout";
    public static final String LOCKTOKEN_NODE = "locktoken";
    public static final String LOCKENTRY_NODE = "lockentry";
    public static final String LOCKINFO_NODE = "lockinfo";
    public static final String WRITE_NODE = "write";
    public static final String EXCLUSIVE_NODE = "exclusive";
    public static final String SHARED_NODE = "shared";
    public static final String HREF_NODE = "href";
    public static final String LINK_NODE = "link";
    public static final String SRC_NODE = "src";
    public static final String DST_NODE = "dst";
    public static final String MULTISTATUS_NODE = "multistatus";
    public static final String RESPONSE_NODE = "response";
    public static final String PROPSTAT_NODE = "propstat";
    public static final String RESPONSEDESC_NODE = "responsedescription";
    public static final String STATUS_NODE = "status";
    public static final String PROP_NODE = "prop";
    public static final String PROPERTYBEHAVIOR_NODE = "propertybehavior";
    public static final String OMIT_NODE = "omit";
    public static final String KEEPALIVE_NODE = "keepalive";
    public static final String PROPERTYUPDATE_NODE = "propertyupdate";
    public static final String REMOVE_NODE = "remove";
    public static final String SET_NODE = "set";
    public static final String PROPFIND_NODE = "propfind";
    public static final String ALLPROP_NODE = "allprop";
    public static final String PROPNAME_NODE = "propname";
    public static final String COLLECTION_NODE = "collection";
    public static final String CREATIONDATE_NODE = "creationdate";
    public static final String DISPLAYNAME_NODE = "displayname";
    public static final String GETCONTENTLANGUAGE_NODE = "getcontentlanguage";
    public static final String GETCONTENTLENGTH_NODE = "getcontentlength";
    public static final String GETCONTENTTYPE_NODE = "getcontenttype";
    public static final String GETETAG_NODE = "getetag";
    public static final String GETLASTMODIFIED_NODE = "getlastmodified";
    public static final String LOCKDISCOVERY_NODE = "lockdiscovery";
    public static final String RESOURCETYPE_NODE = "resourcetype";
    public static final String SOURCE_NODE = "source";
    public static final String SUPPORTEDLOCK_NODE = "supportedlock";
    public static final String ISCOLLECTION_NODE = "iscollection";
    public static final String ISSHARED_NODE = "isshared";
    public static final String ISHIDDEN_NODE = "ishidden";
    public static final String ISFOLDER_NODE = "isfolder";
    protected Element element = null;
    String[] nodenames = null;

    public static Node getNodeNS(Node node, String string, String string2) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getLocalName().equals(string)) continue;
            if (string2 != null) {
                String string3 = node2.getNamespaceURI();
                if (string3 == null || !string3.equals(string2)) continue;
                return node2;
            }
            return node2;
        }
        return null;
    }

    public static void addNodeNS(Node node, Node node2) {
        Document document = node.getOwnerDocument();
        String string = node2.getNamespaceURI();
        String string2 = node2.getPrefix();
        if (string != null) {
            if (string2 != null) {
                String string3;
                Element element = document.getDocumentElement();
                if (element.getAttribute(string3 = "xmlns:" + string2).equals("")) {
                    element.setAttribute(string3, string);
                }
            } else if (string.equals("DAV:")) {
                DAVNode.setPrefix(node2, "D", string);
            }
        }
        node.appendChild(node2);
    }

    public static void exportChildren(Document document, Node node, Node node2, boolean bl) throws DOMException {
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            if (node3.getNodeType() != 1) continue;
            Node node4 = document.importNode(node3, bl);
            DAVNode.addNodeNS(node, node4);
        }
    }

    public static Node importNode(Document document, Element element, Node node, boolean bl) {
        Element element2 = document.getDocumentElement();
        Node node2 = document.importNode(node, bl);
        String string = node2.getNamespaceURI();
        if (string != null) {
            String string2 = node2.getPrefix();
            if (string2 != null) {
                String string3 = "xmlns:" + string2;
                String string4 = element2.getAttribute(string3);
                if (string4.equals("")) {
                    element2.setAttribute(string3, string);
                } else if (!string4.equals(string)) {
                    string2 = "D" + string2;
                    string3 = "xmlns:" + string2;
                    while ((string4 = element2.getAttribute(string3)) != null) {
                        string2 = "D" + string2;
                        string3 = "xmlns:" + string2;
                    }
                    element2.setAttribute(string3, string);
                    DAVNode.setPrefix(node2, string2, string);
                }
            } else if (string.equals("DAV:")) {
                DAVNode.setPrefix(node2, "D", string);
            }
        }
        element.appendChild(node2);
        return node2;
    }

    private static void setPrefix(Node node, String string, String string2) {
        String string3 = node.getNamespaceURI();
        if (string3 != null && string3.equals(string2)) {
            node.setPrefix(string);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            DAVNode.setPrefix(node2, string, string2);
        }
    }

    public Node getNode() {
        return this.element;
    }

    public Element[] getChildrenElements() {
        Vector<Element> vector = new Vector<Element>();
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            vector.addElement((Element)node);
        }
        Object[] objectArray = new Element[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Node getNodeNS(String string, String string2) {
        return DAVNode.getNodeNS(this.element, string, string2);
    }

    public String getTextValue() {
        return this.getTextChildValue(this.element);
    }

    public String getTextChildValue(Node node) {
        if (node == null) {
            return null;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 3) continue;
            return node2.getNodeValue();
        }
        return null;
    }

    public String getTextChildValueNS(String string, String string2) {
        return this.getTextChildValue(this.getNodeNS(string, string2));
    }

    public void addNode(Node node) {
        this.element.appendChild(node);
    }

    public void addNodeNS(Node node) {
        DAVNode.addNodeNS(this.element, node);
    }

    public static Vector getDAVElementsByTagName(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getLocalName().equals(string) || node2.getNamespaceURI() == null || !node2.getNamespaceURI().equals("DAV:")) continue;
            vector.addElement(node2);
        }
        return vector;
    }

    public static Node getDAVNode(Node node, String string) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getLocalName().equals(string) || node2.getNamespaceURI() == null || !node2.getNamespaceURI().equals("DAV:")) continue;
            return node2;
        }
        return null;
    }

    public static Element addDAVNode(Node node, String string, String string2) throws DOMException {
        Document document = node.getOwnerDocument();
        Element element = document.createElementNS("DAV:", "D:" + string);
        if (string2 != null) {
            element.appendChild(document.createTextNode(string2));
        }
        node.appendChild(element);
        return element;
    }

    public static String[] getMultipleTextChildValue(Node node, String string) {
        Vector<String> vector = new Vector<String>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 3 || !node2.getLocalName().equals(string) || node2.getNamespaceURI() == null || !node2.getNamespaceURI().equals("DAV:")) continue;
            vector.addElement(node2.getNodeValue());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Vector getDAVElementsByTagName(String string) {
        return DAVNode.getDAVElementsByTagName(this.element, string);
    }

    public Node getDAVNode(String string) {
        return DAVNode.getDAVNode(this.element, string);
    }

    public String getTextChildValue(String string) {
        return this.getTextChildValue(this.getDAVNode(string));
    }

    public String[] getMultipleTextChildValue(String string) {
        return DAVNode.getMultipleTextChildValue(this.element, string);
    }

    public String[] getDAVNodeNames() {
        if (this.nodenames == null) {
            Vector<String> vector = new Vector<String>();
            for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || node.getNamespaceURI() == null || !node.getNamespaceURI().equals("DAV:")) continue;
                vector.addElement(node.getLocalName());
            }
            this.nodenames = new String[vector.size()];
            vector.copyInto(this.nodenames);
        }
        return this.nodenames;
    }

    public Element addDAVNode(String string, String string2) throws DOMException {
        return DAVNode.addDAVNode(this.element, string, string2);
    }

    public void addDAVNode(DAVNode dAVNode) {
        this.element.appendChild(dAVNode.getNode());
    }

    public void addDAVNodes(DAVNode[] dAVNodeArray) {
        if (dAVNodeArray != null) {
            int n = dAVNodeArray.length;
            for (int i = 0; i < n; ++i) {
                this.element.appendChild(dAVNodeArray[i].getNode());
            }
        }
    }

    public boolean equals(DAVNode dAVNode) {
        return this.element == dAVNode.getNode();
    }

    DAVNode(Element element) {
        this.element = element;
    }
}

