/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterMatchNoRegEx
implements FilenameFilter {
    private final String[] m_aRegExs;

    public FilenameFilterMatchNoRegEx(@Nonnull @Nonempty String sRegEx) {
        this(new String[]{sRegEx});
    }

    public FilenameFilterMatchNoRegEx(String ... aRegExs) {
        if (ArrayHelper.isEmpty(aRegExs)) {
            throw new IllegalArgumentException("empty array passed");
        }
        this.m_aRegExs = aRegExs;
    }

    @Override
    public boolean accept(@Nonnull File aDir, @Nonnull String sName) {
        String sRealName = FilenameHelper.getSecureFilename(sName);
        if (sRealName == null) {
            return false;
        }
        for (String sRegEx : this.m_aRegExs) {
            if (!RegExHelper.stringMatchesPattern(sRegEx, sRealName)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new ToStringGenerator(this).append("regExs", this.m_aRegExs).toString();
    }
}

