/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MathHelper {
    private static final long LONG_HIGH_BITS = Integer.MIN_VALUE;
    private static final MathHelper s_aInstance = new MathHelper();

    private MathHelper() {
    }

    public static double getDividedDouble(int nDividend, int nDivisor) {
        double dDividend = nDividend;
        double dDivisor = nDivisor;
        return dDividend / dDivisor;
    }

    @Nonnull
    public static BigDecimal getDividedBigDecimal(int nDividend, int nDivisor) throws ArithmeticException {
        BigDecimal aDividend = BigDecimal.valueOf(nDividend);
        BigDecimal aDivisor = BigDecimal.valueOf(nDivisor);
        return aDividend.divide(aDivisor);
    }

    public static int getIntDividedCeil(int nDividend, int nDivisor) {
        return MathHelper.getIntDivided(nDividend, nDivisor, RoundingMode.CEILING);
    }

    public static int getIntDividedFloor(int nDividend, int nDivisor) {
        return MathHelper.getIntDivided(nDividend, nDivisor, RoundingMode.FLOOR);
    }

    public static int getIntDivided(int nDividend, int nDivisor, @Nonnull RoundingMode eRoundingMode) {
        return new BigDecimal(nDividend).divide(new BigDecimal(nDivisor), eRoundingMode).intValue();
    }

    public static long getLongDividedCeil(long nDividend, long nDivisor) {
        return MathHelper.getLongDivided(nDividend, nDivisor, RoundingMode.CEILING);
    }

    public static long getLongDividedFloor(long nDividend, long nDivisor) {
        return MathHelper.getLongDivided(nDividend, nDivisor, RoundingMode.FLOOR);
    }

    public static long getLongDivided(long nDividend, long nDivisor, @Nonnull RoundingMode eRoundingMode) {
        return new BigDecimal(nDividend).divide(new BigDecimal(nDivisor), eRoundingMode).longValue();
    }

    public static boolean canConvertLongToInt(long nValue) {
        return (nValue & Integer.MIN_VALUE) == 0L || (nValue & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    @CheckReturnValue
    public static int getLongAsInt(long nValue, int nFallback) {
        return MathHelper.canConvertLongToInt(nValue) ? (int)nValue : nFallback;
    }

    public static int getMaxInt(int nValue, int ... aValues) {
        int ret = nValue;
        for (int n : aValues) {
            ret = Math.max(ret, n);
        }
        return ret;
    }

    public static long getMaxLong(long nValue, long ... aValues) {
        long ret = nValue;
        for (long n : aValues) {
            ret = Math.max(ret, n);
        }
        return ret;
    }

    public static double getMaxFloat(float fValue, float ... aValues) {
        float ret = fValue;
        for (float f : aValues) {
            ret = Math.max(ret, f);
        }
        return ret;
    }

    public static double getMaxDouble(double dValue, double ... aValues) {
        double ret = dValue;
        for (double d : aValues) {
            ret = Math.max(ret, d);
        }
        return ret;
    }

    @Nonnull
    public static BigDecimal getMaxBigDecimal(@Nonnull BigDecimal aValue, BigDecimal ... aValues) {
        BigDecimal ret = aValue;
        for (BigDecimal a : aValues) {
            if (a.compareTo(ret) <= 0) continue;
            ret = a;
        }
        return ret;
    }

    @Nonnull
    public static BigInteger getMaxBigInteger(@Nonnull BigInteger aValue, BigInteger ... aValues) {
        BigInteger ret = aValue;
        for (BigInteger a : aValues) {
            if (a.compareTo(ret) <= 0) continue;
            ret = a;
        }
        return ret;
    }

    public static int getMinInt(int nValue, int ... aValues) {
        int ret = nValue;
        for (int n : aValues) {
            ret = Math.min(ret, n);
        }
        return ret;
    }

    public static long getMinLong(long nValue, long ... aValues) {
        long ret = nValue;
        for (long n : aValues) {
            ret = Math.min(ret, n);
        }
        return ret;
    }

    public static double getMinFloat(float fValue, float ... aValues) {
        float ret = fValue;
        for (float f : aValues) {
            ret = Math.min(ret, f);
        }
        return ret;
    }

    public static double getMinDouble(double dValue, double ... aValues) {
        double ret = dValue;
        for (double d : aValues) {
            ret = Math.min(ret, d);
        }
        return ret;
    }

    @Nonnull
    public static BigDecimal getMinBigDecimal(@Nonnull BigDecimal aValue, BigDecimal ... aValues) {
        BigDecimal ret = aValue;
        for (BigDecimal a : aValues) {
            if (a.compareTo(ret) >= 0) continue;
            ret = a;
        }
        return ret;
    }

    @Nonnull
    public static BigInteger getMinBigInteger(@Nonnull BigInteger aValue, BigInteger ... aValues) {
        BigInteger ret = aValue;
        for (BigInteger a : aValues) {
            if (a.compareTo(ret) >= 0) continue;
            ret = a;
        }
        return ret;
    }

    @Nonnegative
    public static int abs(int nValue) {
        if (nValue == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Integer.MIN_VALUE!");
        }
        return Math.abs(nValue);
    }

    @Nonnegative
    public static long abs(long nValue) {
        if (nValue == Long.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Long.MIN_VALUE!");
        }
        return Math.abs(nValue);
    }

    @Nonnegative
    public static float abs(float fValue) {
        return Math.abs(fValue);
    }

    @Nonnegative
    public static double abs(double dValue) {
        return Math.abs(dValue);
    }

    @Nonnull
    public static BigDecimal abs(@Nonnull BigDecimal aValue) {
        return aValue.abs();
    }

    @Nonnull
    public static BigInteger abs(@Nonnull BigInteger aValue) {
        return aValue.abs();
    }
}

