/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.convert;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.convert.IMicroTypeConverter;
import com.phloc.commons.microdom.convert.MicroTypeConverterRegistry;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.typeconvert.TypeConverterException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MicroTypeConverter {
    private static final MicroTypeConverter s_aInstance = new MicroTypeConverter();

    private MicroTypeConverter() {
    }

    @Nullable
    public static IMicroElement convertToMicroElement(@Nullable Object aObject, @Nonnull @Nonempty String sTagName) {
        return MicroTypeConverter.convertToMicroElement(aObject, null, sTagName);
    }

    @Nullable
    public static IMicroElement convertToMicroElement(@Nullable Object aObject, @Nullable String sNamespaceURI, @Nonnull @Nonempty String sTagName) throws TypeConverterException {
        if (StringHelper.hasNoText(sTagName)) {
            throw new IllegalArgumentException("tagName is empty");
        }
        if (aObject == null) {
            return null;
        }
        Class<?> aSrcClass = aObject.getClass();
        IMicroTypeConverter aConverter = MicroTypeConverterRegistry.getConverterToMicroElement(aSrcClass);
        if (aConverter == null) {
            throw new TypeConverterException(aSrcClass, IMicroElement.class, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        IMicroElement ret = aConverter.convertToMicroElement(aObject, sNamespaceURI, sTagName);
        if (ret == null) {
            throw new TypeConverterException(aSrcClass, IMicroElement.class, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return ret;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertToNative(@Nullable IMicroElement aElement, @Nonnull Class<DSTTYPE> aDstClass) throws TypeConverterException {
        if (aDstClass == null) {
            throw new NullPointerException("destinationClass");
        }
        if (aElement == null) {
            return null;
        }
        IMicroTypeConverter aConverter = MicroTypeConverterRegistry.getConverterToNative(aDstClass);
        if (aConverter == null) {
            throw new TypeConverterException(IMicroElement.class, aDstClass, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        DSTTYPE ret = aDstClass.cast(aConverter.convertToNative(aElement));
        if (ret == null) {
            throw new TypeConverterException(IMicroElement.class, aDstClass, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return ret;
    }
}

