/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.ls;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.xml.ls.LSResourceData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

@ThreadSafe
public final class CollectingLSResourceResolver
implements LSResourceResolver {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final List<LSResourceData> m_aList = new ArrayList<LSResourceData>();
    private final LSResourceResolver m_aParentResolver;

    public CollectingLSResourceResolver() {
        this(null);
    }

    public CollectingLSResourceResolver(@Nullable LSResourceResolver aParentResolver) {
        this.m_aParentResolver = aParentResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<LSResourceData> getAllRequestedResources() {
        this.m_aRWLock.readLock().lock();
        try {
            List<LSResourceData> list = ContainerHelper.newList(this.m_aList);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LSInput resolveResource(String sType, String sNamespaceURI, String sPublicId, String sSystemId, String sBaseURI) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aList.add(new LSResourceData(sType, sNamespaceURI, sPublicId, sSystemId, sBaseURI));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return this.m_aParentResolver == null ? null : this.m_aParentResolver.resolveResource(sType, sNamespaceURI, sPublicId, sSystemId, sBaseURI);
    }
}

