/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSSelectorMemberFunctionLike
implements ICSSSelectorMember {
    private final String m_sFuncName;
    private final CSSExpression m_aParamExpr;

    public CSSSelectorMemberFunctionLike(@Nonnull @Nonempty String sFuncName, @Nonnull CSSExpression aParamExpr) {
        if (StringHelper.hasNoText((CharSequence)sFuncName)) {
            throw new IllegalArgumentException("empty function name is not allowed");
        }
        if (!sFuncName.endsWith("(")) {
            throw new IllegalArgumentException("function name must end with a '('");
        }
        if (aParamExpr == null) {
            throw new NullPointerException("paramExpr");
        }
        this.m_sFuncName = sFuncName;
        this.m_aParamExpr = aParamExpr;
    }

    @Nonnull
    @Nonempty
    public String getFunctionName() {
        return this.m_sFuncName;
    }

    @Nonnull
    public CSSExpression getParameterExpression() {
        return this.m_aParamExpr;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return this.m_sFuncName + this.m_aParamExpr.getAsCSSString(aSettings, nIndentLevel) + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSSelectorMemberFunctionLike)) {
            return false;
        }
        CSSSelectorMemberFunctionLike rhs = (CSSSelectorMemberFunctionLike)o;
        return this.m_sFuncName.equals(rhs.m_sFuncName) && this.m_aParamExpr.equals(rhs.m_aParamExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFuncName).append((Object)this.m_aParamExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("functionName", (Object)this.m_sFuncName).append("paramExpr", (Object)this.m_aParamExpr).toString();
    }
}

