/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.test;

import com.thaiopensource.datatype.xsd.regex.Regex;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Service;
import com.thaiopensource.util.Utf16;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;

public class CategoryTest {
    private static final String categories = "LMNPZSC";
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private final Regex[] categoryPosRegexes = new Regex["LMNPZSC".length()];
    private final Regex[] categoryNegRegexes = new Regex["LMNPZSC".length()];
    private final Regex[] subCategoryPosRegexes = new Regex["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private final Regex[] subCategoryNegRegexes = new Regex["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    int nFail = 0;

    public static void main(String[] stringArray) throws IOException, RegexSyntaxException {
        RegexEngine regexEngine;
        if (stringArray.length != 2) {
            System.err.println("usage: " + CategoryTest.class.getName() + " engineClass UnicodeData");
            System.exit(2);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(stringArray[1])));
        Enumeration enumeration = new Service(RegexEngine.class).getProviders();
        do {
            if (enumeration.hasMoreElements()) continue;
            System.err.println("couldn't find regex engine");
            System.exit(2);
        } while (!(regexEngine = (RegexEngine)enumeration.nextElement()).getClass().getName().equals(stringArray[0]));
        int n = new CategoryTest(regexEngine).testAll(bufferedReader);
        System.err.println(n + " tests failed");
        System.exit(n > 0 ? 1 : 0);
    }

    CategoryTest(RegexEngine regexEngine) throws RegexSyntaxException {
        String string;
        int n;
        int n2 = categories.length();
        for (n = 0; n < n2; ++n) {
            string = categories.substring(n, n + 1);
            this.categoryPosRegexes[n] = regexEngine.compile("\\p{" + string + "}");
            this.categoryNegRegexes[n] = regexEngine.compile("\\P{" + string + "}");
        }
        n2 = subCategories.length();
        for (n = 0; n < n2; n += 2) {
            string = subCategories.substring(n, n + 2);
            this.subCategoryPosRegexes[n / 2] = regexEngine.compile("\\p{" + string + "}");
            this.subCategoryNegRegexes[n / 2] = regexEngine.compile("\\P{" + string + "}");
        }
    }

    int testAll(BufferedReader bufferedReader) throws IOException {
        String string;
        int n = -1;
        while ((string = bufferedReader.readLine()) != null) {
            int n2 = string.indexOf(59);
            if (n2 < 0) continue;
            int n3 = Integer.parseInt(string.substring(0, n2), 16);
            int n4 = string.indexOf(59, n2 + 1);
            String string2 = string.substring(n2, n4);
            String string3 = string.substring(n4 + 1, n4 + 3);
            if (n + 1 != n3) {
                String string4 = string2.endsWith(", Last>") ? string3 : "Cn";
                for (int i = n + 1; i < n3; ++i) {
                    this.test(i, string4);
                }
            }
            this.test(n3, string3);
            n = n3;
        }
        ++n;
        while (n < 0x110000) {
            this.test(n, "Cn");
            ++n;
        }
        return this.nFail;
    }

    void test(int n, String string) {
        int n2;
        if (!CategoryTest.isXmlChar(n)) {
            return;
        }
        if (subCategories.indexOf(string) < 0) {
            System.err.println("Missing category: " + string);
            System.exit(2);
        }
        int n3 = categories.length();
        for (n2 = 0; n2 < n3; ++n2) {
            this.check(n, this.categoryPosRegexes[n2], this.categoryNegRegexes[n2], string.charAt(0) == categories.charAt(n2), categories.substring(n2, n2 + 1));
        }
        n3 = subCategories.length();
        for (n2 = 0; n2 < n3; n2 += 2) {
            this.check(n, this.subCategoryPosRegexes[n2 / 2], this.subCategoryNegRegexes[n2 / 2], string.equals(subCategories.substring(n2, n2 + 2)), subCategories.substring(n2, n2 + 2));
        }
    }

    void check(int n, Regex regex, Regex regex2, boolean bl, String string) {
        String string2 = n > 65535 ? new String(new char[]{Utf16.surrogate1(n), Utf16.surrogate2(n)}) : new String(new char[]{(char)n});
        if (regex.matches(string2) != bl) {
            this.fail(n, string);
        }
        if (regex2.matches(string2) != !bl) {
            this.fail(n, "-" + string);
        }
    }

    void fail(int n, String string) {
        ++this.nFail;
        System.err.println("Failed: " + Integer.toHexString(n) + "/" + string);
    }

    static boolean isXmlChar(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
            case 65534: 
            case 65535: {
                return false;
            }
        }
        if (n < 32) {
            return false;
        }
        return n < 55296 || n >= 57344;
    }
}

