/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.format.impl;

import com.phloc.commons.format.IFormatter;
import com.phloc.commons.format.impl.AbstractStringFormatter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringPrefixAndSuffixFormatter
extends AbstractStringFormatter {
    private final String m_sPrefix;
    private final String m_sSuffix;

    public StringPrefixAndSuffixFormatter(@Nonnull String sPrefix, @Nonnull String sSuffix) {
        this(sPrefix, sSuffix, null);
    }

    public StringPrefixAndSuffixFormatter(@Nonnull String sPrefix, @Nonnull String sSuffix, @Nullable IFormatter aNestedFormatter) {
        super(aNestedFormatter);
        if (sPrefix == null) {
            throw new NullPointerException("prefix");
        }
        if (sSuffix == null) {
            throw new NullPointerException("suffix");
        }
        this.m_sPrefix = sPrefix;
        this.m_sSuffix = sSuffix;
    }

    @Override
    protected final String getFormattedValueAsString(@Nullable Object aValue) {
        return this.m_sPrefix + this.getValueAsString(aValue) + this.m_sSuffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringPrefixAndSuffixFormatter)) {
            return false;
        }
        StringPrefixAndSuffixFormatter rhs = (StringPrefixAndSuffixFormatter)o;
        return this.m_sPrefix.equals(rhs.m_sPrefix) && this.m_sSuffix.equals(rhs.m_sSuffix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).append(this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("prefix", this.m_sPrefix).append("suffix", this.m_sSuffix).toString();
    }
}

