/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.log;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IHasErrorLevels;
import com.phloc.commons.log.LogMessage;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.IClearable;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InMemoryLogger
implements Iterable<LogMessage>,
IHasSize,
IClearable,
IHasErrorLevels {
    private final List<LogMessage> m_aMessages = new ArrayList<LogMessage>();

    public void log(@Nonnull EErrorLevel eErrorLevel, @Nonnull Object aMsg) {
        this.log(eErrorLevel, aMsg, null);
    }

    public void log(@Nonnull EErrorLevel eErrorLevel, @Nonnull Object aMsg, @Nullable Throwable t) {
        this.m_aMessages.add(new LogMessage(eErrorLevel, aMsg, t));
    }

    public void error(@Nonnull Object aMsg) {
        this.error(aMsg, null);
    }

    public void error(@Nonnull Object aMsg, @Nullable Throwable t) {
        this.log(EErrorLevel.ERROR, aMsg, t);
    }

    public void warn(@Nonnull Object aMsg) {
        this.warn(aMsg, null);
    }

    public void warn(@Nonnull Object aMsg, @Nullable Throwable t) {
        this.log(EErrorLevel.WARN, aMsg, t);
    }

    public void info(@Nonnull Object aMsg) {
        this.log(EErrorLevel.INFO, aMsg, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<LogMessage> getAllMessages() {
        return ContainerHelper.newList(this.m_aMessages);
    }

    @Override
    @Nonnull
    public Iterator<LogMessage> iterator() {
        return this.m_aMessages.iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aMessages.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aMessages.isEmpty();
    }

    @Override
    public boolean containsOnlySuccess() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isSuccess()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        int ret = 0;
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isSuccess()) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public boolean containsOnlyFailure() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isFailure()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        int ret = 0;
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isFailure()) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public boolean containsOnlyError() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isNoError()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneError() {
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        int ret = 0;
        for (LogMessage aMessage : this.m_aMessages) {
            if (!aMessage.isError()) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aMessages.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMessages.clear();
        return EChange.CHANGED;
    }

    public String toString() {
        return new ToStringGenerator(this).append("messages", this.m_aMessages).toString();
    }
}

