/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.FrameTreeListener;
import org.w3c.jigadm.gui.ServerBrowser;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.widgets.MessagePopup;
import org.w3c.tools.widgets.NodeHandler;
import org.w3c.tools.widgets.TreeBrowser;
import org.w3c.tools.widgets.TreeNode;

public class FrameBrowser
extends TreeBrowser
implements NodeHandler {
    public static final boolean debug = false;
    Image frameopened = null;
    Image frameicon = null;
    ServerBrowser serverBrowser = null;
    FrameTreeListener tl = null;
    TreeNode lastn = null;
    RemoteResourceWrapper rootResource;
    boolean locked;
    private Dimension preferredSize = null;

    protected void errorPopup(String string, Exception exception) {
        new MessagePopup(string + " : " + exception.getMessage()).show();
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(120, 100);
        }
        return this.preferredSize;
    }

    private final Frame getFrame(Component component) {
        while (!(component instanceof Frame)) {
            if ((component = component.getParent()) != null) continue;
            return null;
        }
        return (Frame)component;
    }

    public void setCursor(int n) {
        this.getFrame(this.serverBrowser).setCursor(new Cursor(n));
        Toolkit.getDefaultToolkit().sync();
    }

    protected synchronized boolean getLock() {
        if (this.locked) {
            return false;
        }
        this.setCursor(3);
        this.locked = true;
        return true;
    }

    protected synchronized void unlock() {
        this.locked = false;
        this.setCursor(0);
    }

    public RemoteResourceWrapper getRootWrapper() {
        return this.rootResource;
    }

    public void renameNode(RemoteResourceWrapper remoteResourceWrapper, String string) {
        TreeNode treeNode = this.getNode(remoteResourceWrapper);
        if (treeNode != null) {
            try {
                if (remoteResourceWrapper != this.rootResource) {
                    string = this.getFrameName(remoteResourceWrapper.getResource(), string);
                }
            }
            catch (RemoteAccessException remoteAccessException) {
                // empty catch block
            }
            treeNode.setLabel(string);
            this.repaint();
        }
    }

    public void removeNode(RemoteResourceWrapper remoteResourceWrapper) {
        if (this.getLock()) {
            if (this.getNode(remoteResourceWrapper) != null) {
                this.removeBranch(this.getNode(remoteResourceWrapper));
                this.tl.nodeRemoved(remoteResourceWrapper);
            }
            this.unlock();
            this.repaint();
        }
    }

    public void insertNode(RemoteResourceWrapper remoteResourceWrapper, RemoteResourceWrapper remoteResourceWrapper2) {
        RemoteResource remoteResource = remoteResourceWrapper2.getResource();
        String string = null;
        try {
            string = this.getFrameName(remoteResource);
        }
        catch (RemoteAccessException remoteAccessException) {
            this.errorPopup("RemoteAccessException", remoteAccessException);
        }
        this.insertNode(remoteResourceWrapper, remoteResourceWrapper2, string);
    }

    public void insertNode(RemoteResourceWrapper remoteResourceWrapper, RemoteResourceWrapper remoteResourceWrapper2, String string) {
        TreeNode treeNode;
        boolean bl = false;
        if (remoteResourceWrapper == null) {
            System.out.println("Error null father");
        }
        if ((treeNode = this.getNode(remoteResourceWrapper)).getChildren() == -1) {
            return;
        }
        if (treeNode == null) {
            return;
        }
        try {
            bl = remoteResourceWrapper2.getResource().isContainer();
        }
        catch (RemoteAccessException remoteAccessException) {
            this.errorPopup("RemoteAccessException", remoteAccessException);
        }
        this.insert(treeNode, remoteResourceWrapper2, this, string, this.frameicon);
        this.repaint();
    }

    protected RemoteResourceWrapper getResources(RemoteResourceWrapper remoteResourceWrapper, String string) {
        RemoteResource remoteResource = null;
        if (remoteResourceWrapper != null) {
            try {
                remoteResource = remoteResourceWrapper.getResource().loadResource(string);
            }
            catch (RemoteAccessException remoteAccessException) {
                this.errorPopup("RemoteAccessException", remoteAccessException);
                remoteAccessException.printStackTrace();
            }
        }
        return new RemoteResourceWrapper(remoteResourceWrapper, remoteResource, this.serverBrowser);
    }

    private final Image getImage(String string) {
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameBrowser(FrameTreeListener frameTreeListener, RemoteResourceWrapper remoteResourceWrapper) {
        boolean bl = false;
        RemoteResource remoteResource = null;
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        this.serverBrowser = remoteResourceWrapper.getBrowser();
        this.tl = frameTreeListener;
        this.locked = false;
        this.frameicon = this.getImage(propertyManager.getIconLocation("frame"));
        this.frameopened = this.getImage(propertyManager.getIconLocation("frameopened"));
        this.rootResource = remoteResourceWrapper;
        String string = null;
        while (!bl) {
            try {
                bl = true;
                remoteResource = remoteResourceWrapper.getResource();
                string = (String)remoteResource.getValue("identifier");
            }
            catch (RemoteAccessException remoteAccessException) {
                if (remoteAccessException.getMessage().equals("Unauthorized")) {
                    bl = false;
                    continue;
                }
                this.errorPopup("Can't read resource identifier", remoteAccessException);
            }
            finally {
                if (bl) continue;
                this.serverBrowser.popupDialog("admin");
            }
        }
        if (string != null) {
            this.initialize(this.rootResource, string, this, this.frameicon);
        }
    }

    public void notifySelect(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.tl != null) {
            this.tl.editedChanged(this, (RemoteResourceWrapper)treeNode.getItem());
        }
        treeBrowser.unselect(this.lastn);
        treeBrowser.select(treeNode);
        treeBrowser.repaint();
        this.lastn = treeNode;
    }

    public void notifyExecute(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.tl != null) {
            this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
        }
        if (!treeNode.equals(this.lastn)) {
            treeBrowser.unselect(this.lastn);
            this.lastn = null;
        }
        treeBrowser.repaint();
    }

    public void notifyExpand(TreeBrowser treeBrowser, TreeNode treeNode) {
        new Expander(treeBrowser, treeNode).start();
    }

    public boolean isDirectory(TreeBrowser treeBrowser, TreeNode treeNode) {
        return true;
    }

    public String getFrameName(RemoteResource remoteResource, String string) throws RemoteAccessException {
        String string2 = remoteResource.getClassHierarchy()[0];
        String string3 = string2.substring(string2.lastIndexOf(46) + 1);
        return string3.concat(" (").concat(string).concat(")");
    }

    public String getFrameName(RemoteResource remoteResource) throws RemoteAccessException {
        String string = remoteResource.getClassHierarchy()[0];
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = (String)remoteResource.getValue("identifier");
        return string2.concat(" (").concat(string3).concat(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyExpander(TreeBrowser treeBrowser, TreeNode treeNode) {
        boolean bl = true;
        if (this.tl != null) {
            this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
        }
        RemoteResourceWrapper remoteResourceWrapper = null;
        RemoteResource remoteResource = null;
        remoteResourceWrapper = (RemoteResourceWrapper)treeNode.getItem();
        if (remoteResourceWrapper == null) {
            return;
        }
        remoteResource = remoteResourceWrapper.getResource();
        this.setCursor(3);
        try {
            RemoteResource[] remoteResourceArray = remoteResource.getFrames();
            if (remoteResourceArray != null) {
                for (int i = 0; i < remoteResourceArray.length; ++i) {
                    RemoteResourceWrapper remoteResourceWrapper2 = new RemoteResourceWrapper(remoteResourceWrapper, remoteResourceArray[i], this.serverBrowser);
                    treeBrowser.insert(treeNode, remoteResourceWrapper2, this, this.getFrameName(remoteResourceArray[i]), this.frameicon);
                }
            }
        }
        catch (RemoteAccessException remoteAccessException) {
            if (remoteAccessException.getMessage().equals("Unauthorized")) {
                bl = false;
            } else {
                this.errorPopup("RemoteAccessException", remoteAccessException);
                remoteAccessException.printStackTrace();
            }
        }
        finally {
            if (!bl) {
                this.serverBrowser.popupDialog("admin");
            }
        }
        this.setCursor(0);
        treeNode.setIcon(this.frameopened);
        treeBrowser.repaint();
    }

    public void notifyCollapse(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.getLock()) {
            if (this.tl != null) {
                this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
            }
            treeBrowser.collapse(treeNode);
            if (!treeNode.equals(this.lastn)) {
                treeBrowser.unselect(this.lastn);
                this.lastn = null;
            }
            this.unlock();
            treeBrowser.repaint();
            treeNode.setIcon(this.frameicon);
        }
    }

    class Expander
    extends Thread {
        TreeBrowser browser;
        TreeNode nd;

        public void run() {
            if (FrameBrowser.this.getLock()) {
                FrameBrowser.this.notifyExpander(this.browser, this.nd);
                FrameBrowser.this.unlock();
            }
        }

        Expander(TreeBrowser treeBrowser, TreeNode treeNode) {
            this.browser = treeBrowser;
            this.nd = treeNode;
        }
    }
}

