/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.mns;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.mns.ContextMap;
import com.thaiopensource.validate.mns.ElementsOrAttributes;
import com.thaiopensource.validate.mns.Hashset;
import com.thaiopensource.validate.mns.NamespaceFilteredAttributes;
import com.thaiopensource.validate.mns.SchemaImpl;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ValidatorImpl
extends DefaultHandler
implements Validator {
    private static final String BEARER_URI = "";
    private static final String BEARER_LOCAL_NAME = "#bearer";
    private SchemaImpl.Mode currentMode;
    private int laxDepth = 0;
    private final ErrorHandler eh;
    private final PropertyMap properties;
    private Locator locator;
    private Subtree subtrees = null;
    private final Hashset attributeNamespaces = new Hashset();
    private PrefixMapping prefixMapping = null;
    private final Localizer localizer = new Localizer(ValidatorImpl.class);
    private final Hashtable validatorCache = new Hashtable();

    ValidatorImpl(SchemaImpl.Mode mode, PropertyMap propertyMap) {
        this.currentMode = mode;
        this.properties = propertyMap;
        this.eh = ValidateProperty.ERROR_HANDLER.get(propertyMap);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Subtree subtree = this.subtrees;
        while (this.wantsEvent(subtree)) {
            subtree.validator.getContentHandler().characters(cArray, n, n2);
            subtree = subtree.parent;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        Subtree subtree = this.subtrees;
        while (this.wantsEvent(subtree)) {
            subtree.validator.getContentHandler().ignorableWhitespace(cArray, n, n2);
            subtree = subtree.parent;
        }
    }

    private SchemaImpl.Mode getMode() {
        SchemaImpl.Mode mode;
        if (this.subtrees != null && (mode = (SchemaImpl.Mode)this.subtrees.contextMap.get(this.subtrees.context)) != null) {
            return mode;
        }
        return this.currentMode;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Object object2;
        if (this.namespaceCovered(string)) {
            this.subtrees.context.push(new Name(string, string2));
        } else {
            object2 = this.getMode();
            object = ((SchemaImpl.Mode)object2).getElementAction(string);
            if (object == null) {
                if (this.laxDepth == 0 && !((SchemaImpl.Mode)object2).getLax().containsElements()) {
                    this.error("element_undeclared_namespace", string);
                }
                ++this.laxDepth;
            } else {
                this.subtrees = new Subtree(((SchemaImpl.ElementAction)object).getCoveredNamespaces(), ((SchemaImpl.ElementAction)object).getContextMap(), ((SchemaImpl.ElementAction)object).getPrune(), this.createValidator(((SchemaImpl.ElementAction)object).getSchema()), ((SchemaImpl.ElementAction)object).getSchema(), this.currentMode, this.laxDepth, this.subtrees);
                this.subtrees.context.push(new Name(string, string2));
                this.currentMode = ((SchemaImpl.ElementAction)object).getMode();
                this.laxDepth = 0;
                this.startSubtree(this.subtrees.validator.getContentHandler());
            }
        }
        object2 = this.subtrees;
        while (this.wantsEvent((Subtree)object2)) {
            object = ((Subtree)object2).prune.containsAttributes() ? new NamespaceFilteredAttributes(string, true, attributes) : attributes;
            ((Subtree)object2).validator.getContentHandler().startElement(string, string2, string3, (Attributes)object);
            object2 = ((Subtree)object2).parent;
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string4 = attributes.getURI(i);
            if (string4.equals(BEARER_URI) || string4.equals(string) || this.namespaceCovered(string4) || this.attributeNamespaces.contains(string4)) continue;
            this.attributeNamespaces.add(string4);
            this.validateAttributes(string4, attributes);
        }
        this.attributeNamespaces.clear();
    }

    private boolean namespaceCovered(String string) {
        return this.laxDepth == 0 && this.subtrees != null && this.subtrees.coveredNamespaces.contains(string);
    }

    private boolean wantsEvent(Subtree subtree) {
        return subtree != null && (!subtree.prune.containsElements() || this.laxDepth == 0 && subtree == this.subtrees);
    }

    private void validateAttributes(String string, Attributes attributes) throws SAXException {
        SchemaImpl.Mode mode = this.getMode();
        Schema schema = mode.getAttributesSchema(string);
        if (schema == null) {
            if (!mode.getLax().containsAttributes()) {
                this.error("attributes_undeclared_namespace", string);
            }
            return;
        }
        Validator validator = this.createValidator(schema);
        ContentHandler contentHandler = validator.getContentHandler();
        this.startSubtree(contentHandler);
        contentHandler.startElement(BEARER_URI, BEARER_LOCAL_NAME, BEARER_LOCAL_NAME, new NamespaceFilteredAttributes(string, false, attributes));
        contentHandler.endElement(BEARER_URI, BEARER_LOCAL_NAME, BEARER_LOCAL_NAME);
        this.endSubtree(contentHandler);
        this.releaseValidator(schema, validator);
    }

    private void startSubtree(ContentHandler contentHandler) throws SAXException {
        if (this.locator != null) {
            contentHandler.setDocumentLocator(this.locator);
        }
        contentHandler.startDocument();
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            contentHandler.startPrefixMapping(prefixMapping.prefix, prefixMapping.uri);
            prefixMapping = prefixMapping.parent;
        }
    }

    private void endSubtree(ContentHandler contentHandler) throws SAXException {
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            contentHandler.endPrefixMapping(prefixMapping.prefix);
            prefixMapping = prefixMapping.parent;
        }
        contentHandler.endDocument();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Subtree subtree = this.subtrees;
        while (this.wantsEvent(subtree)) {
            subtree.validator.getContentHandler().endElement(string, string2, string3);
            subtree = subtree.parent;
        }
        if (this.laxDepth > 0) {
            --this.laxDepth;
        } else if (!this.subtrees.context.empty()) {
            this.subtrees.context.pop();
            if (this.subtrees.context.empty()) {
                this.endSubtree(this.subtrees.validator.getContentHandler());
                this.releaseValidator(this.subtrees.schema, this.subtrees.validator);
                this.currentMode = this.subtrees.parentMode;
                this.laxDepth = this.subtrees.parentLaxDepth;
                this.subtrees = this.subtrees.parent;
            }
        }
    }

    private Validator createValidator(Schema schema) {
        Stack stack = (Stack)this.validatorCache.get(schema);
        if (stack == null) {
            stack = new Stack();
            this.validatorCache.put(schema, stack);
        }
        if (stack.empty()) {
            return schema.createValidator(this.properties);
        }
        return (Validator)stack.pop();
    }

    private void releaseValidator(Schema schema, Validator validator) {
        validator.reset();
        ((Stack)this.validatorCache.get(schema)).push(validator);
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        this.prefixMapping = new PrefixMapping(string, string2, this.prefixMapping);
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        this.prefixMapping = this.prefixMapping.parent;
    }

    public void reset() {
        this.subtrees = null;
        this.locator = null;
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    private void error(String string, String string2) throws SAXException {
        this.eh.error(new SAXParseException(this.localizer.message(string, string2), this.locator));
    }

    private static class PrefixMapping {
        final String prefix;
        final String uri;
        final PrefixMapping parent;

        PrefixMapping(String string, String string2, PrefixMapping prefixMapping) {
            this.prefix = string;
            this.uri = string2;
            this.parent = prefixMapping;
        }
    }

    private static class Subtree {
        final Subtree parent;
        final Validator validator;
        final Schema schema;
        final Hashset coveredNamespaces;
        final ElementsOrAttributes prune;
        final SchemaImpl.Mode parentMode;
        final int parentLaxDepth;
        final Stack context = new Stack();
        final ContextMap contextMap;

        Subtree(Hashset hashset, ContextMap contextMap, ElementsOrAttributes elementsOrAttributes, Validator validator, Schema schema, SchemaImpl.Mode mode, int n, Subtree subtree) {
            this.coveredNamespaces = hashset;
            this.contextMap = contextMap;
            this.prune = elementsOrAttributes;
            this.validator = validator;
            this.schema = schema;
            this.parentMode = mode;
            this.parentLaxDepth = n;
            this.parent = subtree;
        }
    }
}

