/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.util.Vector;
import org.w3c.jigsaw.http.ShuffleHandler;
import org.w3c.jigsaw.http.ShuffleMessage;
import org.w3c.jigsaw.http.Shuffler;

class ShufflerThread
extends Thread {
    private static final boolean debug = true;
    Shuffler s;
    Vector q;

    synchronized void registerHandler(ShuffleHandler shuffleHandler) {
        this.q.addElement(shuffleHandler);
        this.notifyAll();
    }

    synchronized void processMessage(ShuffleMessage shuffleMessage) {
        int n;
        int n2 = shuffleMessage.id;
        for (n = 0; n < this.q.size(); ++n) {
            ShuffleHandler shuffleHandler = (ShuffleHandler)this.q.elementAt(n);
            if (shuffleHandler.id != n2) continue;
            this.q.removeElementAt(n);
            shuffleHandler.done(shuffleMessage.length);
            return;
        }
        for (n = 0; n < this.q.size(); ++n) {
            System.out.println("waiting for : " + this.q.elementAt(n));
        }
        throw new RuntimeException(this.getClass().getName() + ": received unexpected id " + n2);
    }

    synchronized void waitForHandlers() {
        while (this.q.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void run() {
        while (true) {
            this.waitForHandlers();
            ShuffleMessage shuffleMessage = this.s.getNextMessage();
            this.processMessage(shuffleMessage);
        }
    }

    ShufflerThread(Shuffler shuffler) {
        this.s = shuffler;
        this.q = new Vector();
        this.setPriority(9);
        this.setName("ShufflerThread");
        this.setDaemon(true);
    }
}

