/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.https;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.StringTokenizer;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.w3c.jigsaw.daemon.ServerHandlerInitException;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.https.socket.SSLSocketClient;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.util.ObservableProperties;

public class SSLAdapter {
    private static final Method initCause;
    private static final boolean supportsNewStyleCertificates;
    private static final CertificateFactory x509Factory;
    private static boolean debug;
    private static final Object NO_ENTRY;
    private static final String ALGORITHM = "javax.servlet.request.cipher_suite";
    private static final String KEYSIZE = "javax.servlet.request.key_size";
    private static final String CERTCHAIN = "javax.servlet.request.X509Certificate";
    private static final String CLIENT_CERT_AUTH = "CLIENT_CERT";
    private boolean ssl_enabled = false;
    private httpd daemon = null;
    private URL url = null;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$javax$net$ssl$SSLSession;
    static /* synthetic */ Class class$org$w3c$jigsaw$https$socket$SSLSocketClientFactory;

    public static final void fillInStackTrace(Throwable throwable, Throwable throwable2) {
        if (null != initCause) {
            try {
                Object[] objectArray = new Object[]{throwable2};
                initCause.invoke((Object)throwable, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final SSLSession getSession(Request request) {
        Client client = request.getClient();
        if (client instanceof SSLSocketClient) {
            return ((SSLSocketClient)client).getSession();
        }
        return null;
    }

    private static final Integer getKeySize(String string) {
        if (null != string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    return Integer.valueOf(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return null;
    }

    private static final Integer getKeySize(String string, SSLSession sSLSession) {
        Object object = sSLSession.getValue("javax.servlet.request.key_size." + string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (null == object) {
            Integer n = SSLAdapter.getKeySize(string);
            if (null != n) {
                sSLSession.putValue("javax.servlet.request.key_size." + string, n);
                return n;
            }
            sSLSession.putValue("javax.servlet.request.key_size." + string, NO_ENTRY);
            return null;
        }
        return null;
    }

    private static final Certificate[] getPeerCertificates(SSLSession sSLSession) throws SSLPeerUnverifiedException {
        try {
            if (supportsNewStyleCertificates) {
                return sSLSession.getPeerCertificates();
            }
            if (null != x509Factory) {
                X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
                if (null != x509CertificateArray) {
                    int n = x509CertificateArray.length;
                    Certificate[] certificateArray = new java.security.cert.X509Certificate[n];
                    for (int i = 0; i < n; ++i) {
                        certificateArray[i] = (java.security.cert.X509Certificate)x509Factory.generateCertificate(new ByteArrayInputStream(x509CertificateArray[i].getEncoded()));
                    }
                    return certificateArray;
                }
                throw new SSLPeerUnverifiedException("No peer certificates available");
            }
            throw new SSLPeerUnverifiedException("No suitable certificate compatibility applicable");
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            throw sSLPeerUnverifiedException;
        }
        catch (Exception exception) {
            SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(exception.toString());
            SSLAdapter.fillInStackTrace(sSLPeerUnverifiedException, exception);
            throw sSLPeerUnverifiedException;
        }
    }

    public SSLAdapter(httpd httpd2) {
        if (null == httpd2) {
            throw new NullPointerException("No daemon intance supplied for  creating SSL adapter");
        }
        this.ssl_enabled = false;
        this.daemon = httpd2;
        this.url = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeProperties() throws ServerHandlerInitException {
        ObservableProperties observableProperties = this.daemon.getProperties();
        if (observableProperties.getBoolean("org.w3c.jigsaw.ssl.enabled", true)) {
            String string = observableProperties.getString("org.w3c.jigsaw.http.ClientFactory", null);
            if (null == string) throw new ServerHandlerInitException("No socket client factory specified");
            try {
                Class<?> clazz = Class.forName(string);
                this.ssl_enabled = (class$org$w3c$jigsaw$https$socket$SSLSocketClientFactory == null ? (class$org$w3c$jigsaw$https$socket$SSLSocketClientFactory = SSLAdapter.class$("org.w3c.jigsaw.https.socket.SSLSocketClientFactory")) : class$org$w3c$jigsaw$https$socket$SSLSocketClientFactory).isAssignableFrom(clazz);
            }
            catch (Exception exception) {
                String string2 = "Initialization failed";
                this.daemon.fatal(exception, string2);
                if (debug) {
                    System.out.println(string2);
                    exception.printStackTrace();
                }
                ServerHandlerInitException serverHandlerInitException = new ServerHandlerInitException(exception.getMessage());
                SSLAdapter.fillInStackTrace(serverHandlerInitException, exception);
                throw serverHandlerInitException;
            }
        } else {
            this.ssl_enabled = false;
        }
        this.url = null;
    }

    public void perform(RequestInterface requestInterface) throws ProtocolException {
        block10: {
            Request request = (Request)requestInterface;
            if (this.ssl_enabled) {
                URL uRL = request.getURL();
                try {
                    request.setURL(new URL("https", uRL.getHost(), uRL.getPort(), uRL.getFile()));
                    SSLSession sSLSession = SSLAdapter.getSession(request);
                    if (null == sSLSession) break block10;
                    String string = sSLSession.getCipherSuite();
                    request.setState(ALGORITHM, string);
                    Integer n = SSLAdapter.getKeySize(string, sSLSession);
                    if (null != n) {
                        request.setState(KEYSIZE, n);
                    }
                    try {
                        Certificate[] certificateArray = SSLAdapter.getPeerCertificates(sSLSession);
                        if (certificateArray instanceof java.security.cert.X509Certificate[]) {
                            java.security.cert.X509Certificate[] x509CertificateArray = (java.security.cert.X509Certificate[])certificateArray;
                            request.setState(CERTCHAIN, x509CertificateArray);
                            request.setState("org.w3c.jigsaw.auth.AuthFilter.type", CLIENT_CERT_AUTH);
                            if (x509CertificateArray.length > 0) {
                                request.setState("org.w3c.jigsaw.auth.AuthFilter.user", x509CertificateArray[0].getSubjectDN().getName());
                            }
                        }
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        if (debug) {
                            sSLPeerUnverifiedException.printStackTrace();
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    String string = "Bad url during switching to https";
                    this.daemon.fatal(malformedURLException, string);
                    if (debug) {
                        System.out.println(string);
                        malformedURLException.printStackTrace();
                    }
                    ProtocolException protocolException = new ProtocolException(malformedURLException.getMessage());
                    SSLAdapter.fillInStackTrace(protocolException, malformedURLException);
                    throw protocolException;
                }
            }
        }
    }

    public URL getURL() {
        if (this.url == null) {
            if (this.ssl_enabled) {
                try {
                    if (this.daemon.getPort() != 443) {
                        this.url = new URL("https", this.daemon.getHost(), this.daemon.getPort(), "/");
                    }
                    this.url = new URL("https", this.daemon.getHost(), "/");
                }
                catch (MalformedURLException malformedURLException) {
                    if (debug) {
                        malformedURLException.printStackTrace();
                    }
                    throw new RuntimeException("Unable to construct server uri. (" + malformedURLException.getMessage() + ")");
                }
            } else {
                try {
                    this.url = this.daemon.getPort() != 80 ? new URL("http", this.daemon.getHost(), this.daemon.getPort(), "/") : new URL("http", this.daemon.getHost(), "/");
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Unable to construct server uri. (" + malformedURLException.getMessage() + ")");
                }
            }
        }
        return this.url;
    }

    public boolean sslEnabled() {
        return this.ssl_enabled;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class clazz = class$java$lang$Throwable == null ? (class$java$lang$Throwable = SSLAdapter.class$("java.lang.Throwable")) : class$java$lang$Throwable;
        Class[] classArray = new Class[]{class$java$lang$Throwable == null ? (class$java$lang$Throwable = SSLAdapter.class$("java.lang.Throwable")) : class$java$lang$Throwable};
        Method method = null;
        try {
            method = clazz.getMethod("initCause", classArray);
        }
        catch (Exception exception) {
            method = null;
        }
        finally {
            initCause = method;
        }
        boolean bl = false;
        CertificateFactory certificateFactory = null;
        try {
            bl = null != (class$javax$net$ssl$SSLSession == null ? (class$javax$net$ssl$SSLSession = SSLAdapter.class$("javax.net.ssl.SSLSession")) : class$javax$net$ssl$SSLSession).getMethod("getPeerCertificates", null);
        }
        catch (Exception exception) {
            bl = false;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (Exception exception2) {
                certificateFactory = null;
            }
        }
        finally {
            supportsNewStyleCertificates = bl;
            x509Factory = certificateFactory;
        }
        debug = false;
        NO_ENTRY = "null";
    }
}

