/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.util.Hashtable;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ResourceSpace;
import org.w3c.tools.resources.ServerInterface;
import org.w3c.util.Trace;

public class ResourceContext {
    public static boolean debug = false;
    protected ResourceContext parent = null;
    public Hashtable modules = null;
    protected ResourceSpace space = null;
    protected ServerInterface server = null;
    protected ResourceReference reference = null;
    protected ResourceReference container = null;

    public ResourceReference getContainer() {
        return this.container;
    }

    public ResourceReference getResourceReference() {
        return this.reference;
    }

    public void setResourceReference(ResourceReference resourceReference) {
        this.reference = resourceReference;
        resourceReference.updateContext(this);
    }

    public ResourceSpace getSpace() {
        return this.space;
    }

    public void setSpace(ResourceSpace resourceSpace) {
        this.space = resourceSpace;
    }

    public ServerInterface getServer() {
        return this.server;
    }

    public ResourceContext getParent() {
        return this.parent;
    }

    public synchronized void registerModule(String string, Object object) {
        if (this.modules == null) {
            this.modules = new Hashtable(7);
        }
        this.modules.put(string, object);
    }

    public Object getModule(String string, boolean bl) {
        Object object;
        Object object2 = object = this.modules == null ? null : (Object)this.modules.get(string);
        if (bl && this.parent != null && object == null) {
            object = this.parent.getModule(string, true);
        }
        return object;
    }

    public Object getModule(String string) {
        return this.getModule(string, true);
    }

    public String toString() {
        String string = "\nResourceContext : ";
        if (this.parent == null) {
            string = string + "\n\tparent    : null";
        }
        string = string + "\n\tcontainer : " + this.container;
        string = string + "\n\tspace     : " + this.space;
        string = string + "\n\tserver    : " + this.server;
        return string;
    }

    public ResourceContext(ContainerResource containerResource) {
        this.parent = containerResource.getContext();
        this.container = containerResource.getResourceReference();
        this.space = this.parent != null ? this.parent.space : null;
        ServerInterface serverInterface = this.server = this.parent != null ? this.parent.server : null;
        if (this.container == null && debug) {
            System.out.println("[1] container has no Reference");
            Trace.showTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceContext(ResourceReference resourceReference) {
        try {
            Resource resource = resourceReference.lock();
            this.parent = resource.getContext();
            this.container = resourceReference;
            this.space = this.parent != null ? this.parent.space : null;
            this.server = this.parent != null ? this.parent.server : null;
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
        }
        finally {
            resourceReference.unlock();
        }
    }

    public ResourceContext(ResourceContext resourceContext) {
        this.parent = resourceContext;
        this.container = resourceContext.getResourceReference();
        this.space = resourceContext.space;
        this.server = resourceContext.server;
        if (this.container == null && debug) {
            System.out.println("[2] parent context has no reference");
            Trace.showTrace();
        }
    }

    public ResourceContext(ResourceSpace resourceSpace, ServerInterface serverInterface) {
        this.server = serverInterface;
        this.space = resourceSpace;
        this.container = null;
        this.parent = null;
    }

    public ResourceContext(ServerInterface serverInterface) {
        this.server = serverInterface;
        this.space = null;
        this.container = null;
        this.parent = null;
    }
}

