/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.resources.upgrade.Attribute;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class MimeTypeAttribute
extends Attribute {
    public boolean checkValue(Object object) {
        return object instanceof MimeType || object == null;
    }

    public final int getPickleLength(Object object) {
        String string = ((MimeType)object).toString();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2 + 2;
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeUTF("*none*");
        } else {
            dataOutputStream.writeUTF(((MimeType)object).toString());
        }
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        try {
            return new MimeType(dataInputStream.readUTF());
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            return null;
        }
    }

    public MimeTypeAttribute(String string, MimeType mimeType, Integer n) {
        super(string, mimeType, n);
        this.type = "org.w3c.www.mime.MimeType";
    }
}

