/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.sorter;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.tools.sorter.Comparable;

public class Sorter {
    private static int compare(File file, File file2) {
        if (file.isDirectory() && file2.isFile()) {
            return -1;
        }
        if (file.isFile() && file2.isDirectory()) {
            return 1;
        }
        return file.compareTo(file2);
    }

    public static void orderedFileInsert(File file, Vector vector) {
        int n = 0;
        int n2 = vector.size() - 1;
        int n3 = -1;
        File file2 = null;
        int n4 = 0;
        if (n2 >= n) {
            while (n2 - n > 1) {
                n3 = (n2 - n) / 2 + n;
                file2 = (File)vector.elementAt(n3);
                n4 = Sorter.compare(file2, file);
                if (n4 == 0) {
                    return;
                }
                if (n4 < 0) {
                    n = n3;
                    continue;
                }
                if (n4 <= 0) continue;
                n2 = n3;
            }
            switch (n2 - n) {
                case 0: {
                    file2 = (File)vector.elementAt(n2);
                    if (file2.equals(file)) {
                        return;
                    }
                    n3 = Sorter.compare(file2, file) < 0 ? n2 + 1 : n2;
                    break;
                }
                case 1: {
                    File file3 = (File)vector.elementAt(n);
                    File file4 = (File)vector.elementAt(n2);
                    if (file3.equals(file)) {
                        return;
                    }
                    if (file4.equals(file)) {
                        return;
                    }
                    if (Sorter.compare(file, file3) < 0) {
                        n3 = n;
                        break;
                    }
                    if (Sorter.compare(file, file4) < 0) {
                        n3 = n2;
                        break;
                    }
                    n3 = n2 + 1;
                    break;
                }
                default: {
                    throw new RuntimeException("implementation bug.");
                }
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        vector.insertElementAt(file, n3);
    }

    static void orderedStringInsert(String string, Vector vector) {
        int n = 0;
        int n2 = vector.size() - 1;
        int n3 = -1;
        String string2 = null;
        int n4 = 0;
        if (n2 >= n) {
            while (n2 - n > 1) {
                n3 = (n2 - n) / 2 + n;
                string2 = (String)vector.elementAt(n3);
                n4 = string2.compareTo(string);
                if (n4 == 0) {
                    return;
                }
                if (n4 < 0) {
                    n = n3;
                    continue;
                }
                if (n4 <= 0) continue;
                n2 = n3;
            }
            switch (n2 - n) {
                case 0: {
                    string2 = (String)vector.elementAt(n2);
                    if (string2.equals(string)) {
                        return;
                    }
                    n3 = string2.compareTo(string) < 0 ? n2 + 1 : n2;
                    break;
                }
                case 1: {
                    String string3 = (String)vector.elementAt(n);
                    String string4 = (String)vector.elementAt(n2);
                    if (string3.equals(string)) {
                        return;
                    }
                    if (string4.equals(string)) {
                        return;
                    }
                    if (string.compareTo(string3) < 0) {
                        n3 = n;
                        break;
                    }
                    if (string.compareTo(string4) < 0) {
                        n3 = n2;
                        break;
                    }
                    n3 = n2 + 1;
                    break;
                }
                default: {
                    throw new RuntimeException("implementation bug.");
                }
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        vector.insertElementAt(string, n3);
    }

    static void quickSortStringArray(String[] stringArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        String string = null;
        if (n2 > n) {
            string = stringArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && stringArray[n3].compareTo(string) < 0) {
                    ++n3;
                }
                while (n4 > n && stringArray[n4].compareTo(string) > 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                String string2 = stringArray[n3];
                stringArray[n3] = stringArray[n4];
                stringArray[n4] = string2;
                ++n3;
                --n4;
            }
            if (n < n4) {
                Sorter.quickSortStringArray(stringArray, n, n4);
            }
            if (n3 < n2) {
                Sorter.quickSortStringArray(stringArray, n3, n2);
            }
        }
    }

    public static Vector sortStringKeys(Hashtable hashtable) {
        return Sorter.sortStringEnumeration(hashtable.keys());
    }

    public static Vector sortStringEnumeration(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            Sorter.orderedStringInsert((String)enumeration.nextElement(), vector);
        }
        vector.trimToSize();
        return vector;
    }

    static void orderedComparableInsert(Comparable comparable, Vector vector) {
        int n = 0;
        int n2 = vector.size() - 1;
        int n3 = -1;
        Comparable comparable2 = null;
        boolean bl = false;
        if (n2 >= n) {
            while (n2 - n > 1) {
                n3 = (n2 - n) / 2 + n;
                comparable2 = (Comparable)vector.elementAt(n3);
                if (comparable2.greaterThan(comparable)) {
                    n2 = n3;
                    continue;
                }
                n = n3;
            }
            switch (n2 - n) {
                case 0: {
                    comparable2 = (Comparable)vector.elementAt(n2);
                    n3 = comparable2.greaterThan(comparable) ? n2 : n2 + 1;
                    break;
                }
                case 1: {
                    Comparable comparable3 = (Comparable)vector.elementAt(n);
                    Comparable comparable4 = (Comparable)vector.elementAt(n2);
                    if (comparable3.greaterThan(comparable)) {
                        n3 = n;
                        break;
                    }
                    if (comparable4.greaterThan(comparable)) {
                        n3 = n2;
                        break;
                    }
                    n3 = n2 + 1;
                    break;
                }
                default: {
                    throw new RuntimeException("implementation bug.");
                }
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        vector.insertElementAt(comparable, n3);
    }

    public static Vector sortComparableKeys(Hashtable hashtable) {
        return Sorter.sortComparableEnumeration(hashtable.keys());
    }

    public static Vector sortComparableEnumeration(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            Sorter.orderedComparableInsert((Comparable)enumeration.nextElement(), vector);
        }
        vector.trimToSize();
        return vector;
    }

    public static String[] sortStringArray(String[] stringArray, boolean bl) {
        String[] stringArray2 = stringArray;
        if (!bl) {
            stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        Sorter.quickSortStringArray(stringArray2, 0, stringArray2.length - 1);
        return stringArray2;
    }

    static void quickSortCompArray(Comparable[] comparableArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Comparable comparable = null;
        if (n2 > n) {
            comparable = comparableArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && comparable.greaterThan(comparableArray[n3])) {
                    ++n3;
                }
                while (n4 > n && comparableArray[n4].greaterThan(comparable)) {
                    --n4;
                }
                if (n3 > n4) continue;
                Comparable comparable2 = comparableArray[n3];
                comparableArray[n3] = comparableArray[n4];
                comparableArray[n4] = comparable2;
                ++n3;
                --n4;
            }
            if (n < n4) {
                Sorter.quickSortCompArray(comparableArray, n, n4);
            }
            if (n3 < n2) {
                Sorter.quickSortCompArray(comparableArray, n3, n2);
            }
        }
    }

    public static Comparable[] sortComparableArray(Comparable[] comparableArray, boolean bl) {
        Comparable[] comparableArray2 = comparableArray;
        if (!bl) {
            comparableArray2 = new Comparable[comparableArray.length];
            System.arraycopy(comparableArray, 0, comparableArray2, 0, comparableArray.length);
        }
        Sorter.quickSortCompArray(comparableArray2, 0, comparableArray2.length - 1);
        return comparableArray2;
    }
}

