/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cookies;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.www.http.HttpCookie;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.protocol.http.cookies.DomainNode;

class DomainTree {
    Hashtable nodes = new Hashtable(10);

    protected static String cookie2String(HttpSetCookie httpSetCookie) {
        Date date = new Date();
        return httpSetCookie.getDomain() + "\t" + String.valueOf(httpSetCookie.getSecurity()).toUpperCase() + "\t" + httpSetCookie.getPath() + "\t" + ((long)(httpSetCookie.getMaxAge() * 1000) + date.getTime()) + "\t" + httpSetCookie.getVersion() + "\t" + httpSetCookie.getName() + "\t" + httpSetCookie.getValue() + "\n";
    }

    protected HttpSetCookie string2Cookie(String[] stringArray) {
        HttpSetCookie httpSetCookie = new HttpSetCookie();
        httpSetCookie.setDomain(stringArray[0]);
        httpSetCookie.setSecurity(Boolean.getBoolean(stringArray[1].toLowerCase()));
        httpSetCookie.setPath(stringArray[2]);
        long l = Long.parseLong(stringArray[3]);
        long l2 = new Date().getTime();
        httpSetCookie.setMaxAge((int)((l - l2) / 1000L));
        httpSetCookie.setVersion(Integer.parseInt(stringArray[4]));
        httpSetCookie.setName(stringArray[5]);
        httpSetCookie.setValue(stringArray[6]);
        return httpSetCookie;
    }

    protected synchronized void loadCookies(File file) throws FileNotFoundException {
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            String[] stringArray = new String[8];
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(30);
            block7: while ((n = fileReader.read()) != -1) {
                switch (n) {
                    case 35: {
                        while ((n = fileReader.read()) != 10) {
                            if (n != -1) continue;
                            return;
                        }
                        continue block7;
                    }
                    case 10: {
                        if (n2 <= 0) continue block7;
                        stringArray[n2++] = stringBuffer.toString();
                        HttpSetCookie httpSetCookie = this.string2Cookie(stringArray);
                        if (httpSetCookie.getMaxAge() > 0) {
                            this.insertCookie(httpSetCookie);
                        }
                        stringBuffer = new StringBuffer(30);
                        stringArray = new String[8];
                        n2 = 0;
                        continue block7;
                    }
                    case 9: 
                    case 32: {
                        stringArray[n2++] = stringBuffer.toString();
                        stringBuffer = new StringBuffer(30);
                        continue block7;
                    }
                }
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sync(File file) {
        Enumeration enumeration = this.nodes.elements();
        DomainNode domainNode = null;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write("# Jigsaw client HTTP Cookie File\n");
            fileWriter.write("# This is a generated file!  Do not edit.\n\n");
            while (enumeration.hasMoreElements()) {
                domainNode = (DomainNode)enumeration.nextElement();
                domainNode.sync(fileWriter);
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected boolean isIp(String string) {
        int n = string.length() - 1;
        return string.charAt(n) >= '0' && string.charAt(n) <= '9';
    }

    protected String[] domainParts(String string) {
        if (string == null) {
            return null;
        }
        String string2 = new String(string);
        Vector<String> vector = new Vector<String>(5);
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        while (n < n3) {
            n2 = string2.indexOf(46, n);
            if (n2 == -1) {
                n2 = n3;
            }
            vector.addElement(string2.substring(n, n2));
            n = n2 + 1;
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected HttpCookie setCookie2Cookie(HttpSetCookie httpSetCookie) {
        HttpCookie httpCookie = new HttpCookie();
        if (httpSetCookie != null) {
            httpCookie.setName(httpSetCookie.getName());
            httpCookie.setValue(httpSetCookie.getValue());
            httpCookie.setDomain(httpSetCookie.getDomain());
            httpCookie.setPath(httpSetCookie.getPath());
            httpCookie.setVersion(httpSetCookie.getVersion());
            return httpCookie;
        }
        return null;
    }

    protected void addMatchingPathCookiesInVector(HttpSetCookie[] httpSetCookieArray, String string, Vector vector) {
        for (int i = 0; i < httpSetCookieArray.length; ++i) {
            if (string.equals("/")) {
                vector.addElement(this.setCookie2Cookie(httpSetCookieArray[i]));
                continue;
            }
            if (httpSetCookieArray[i].getPath() == null || !string.startsWith(httpSetCookieArray[i].getPath())) continue;
            vector.addElement(this.setCookie2Cookie(httpSetCookieArray[i]));
        }
    }

    public HttpCookieList getCookies(URL uRL) {
        String string = uRL.getHost();
        String string2 = uRL.getFile();
        String[] stringArray = this.domainParts(string);
        if (stringArray == null) {
            return null;
        }
        Vector vector = new Vector(5);
        int n = 0;
        DomainNode domainNode = null;
        Hashtable hashtable = this.nodes;
        if (this.isIp(string)) {
            domainNode = (DomainNode)hashtable.get(stringArray[n]);
            while (n < stringArray.length) {
                if (domainNode == null) {
                    return null;
                }
                if (domainNode.nbcookies > 0) {
                    this.addMatchingPathCookiesInVector(domainNode.cookies, string2, vector);
                }
                if ((domainNode = n + 1 < stringArray.length ? (DomainNode)hashtable.get(stringArray[++n]) : null) != null) {
                    hashtable = domainNode.nodes;
                    continue;
                }
                break;
            }
        } else {
            n = stringArray.length - 1;
            domainNode = (DomainNode)hashtable.get(stringArray[n]);
            while (n >= 0) {
                if (domainNode == null) {
                    return null;
                }
                if (domainNode.nbcookies > 0) {
                    this.addMatchingPathCookiesInVector(domainNode.cookies, string2, vector);
                }
                if ((domainNode = n > 0 ? (DomainNode)hashtable.get(stringArray[--n]) : null) != null) {
                    hashtable = domainNode.nodes;
                    continue;
                }
                break;
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new HttpCookie[vector.size()];
        vector.copyInto(objectArray);
        return HttpFactory.makeCookieList((HttpCookie[])objectArray);
    }

    public void insertCookie(HttpSetCookie httpSetCookie) {
        String string = httpSetCookie.getDomain();
        String[] stringArray = this.domainParts(string);
        if (stringArray == null) {
            return;
        }
        int n = 0;
        DomainNode domainNode = null;
        Hashtable hashtable = this.nodes;
        if (this.isIp(string)) {
            domainNode = (DomainNode)hashtable.get(stringArray[n]);
            while (true) {
                if (domainNode == null) {
                    domainNode = new DomainNode();
                    hashtable.put(stringArray[n], domainNode);
                }
                if (n == stringArray.length - 1) {
                    domainNode.addCookie(httpSetCookie);
                    return;
                }
                if ((domainNode = (DomainNode)hashtable.get(stringArray[++n])) == null) {
                    domainNode = new DomainNode();
                    hashtable.put(stringArray[n], domainNode);
                }
                hashtable = domainNode.nodes;
            }
        }
        n = stringArray.length - 1;
        domainNode = (DomainNode)hashtable.get(stringArray[n]);
        while (true) {
            if (domainNode == null) {
                domainNode = new DomainNode();
                hashtable.put(stringArray[n], domainNode);
            }
            if (n == 0) {
                domainNode.addCookie(httpSetCookie);
                return;
            }
            if ((domainNode = (DomainNode)hashtable.get(stringArray[--n])) == null) {
                domainNode = new DomainNode();
                hashtable.put(stringArray[n], domainNode);
            }
            hashtable = domainNode.nodes;
        }
    }

    DomainTree() {
    }
}

