/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class LZWNode {
    private final int m_nTableIndex;
    private LZWNode[] m_aChildren;

    public LZWNode() {
        this.m_nTableIndex = -1;
    }

    public LZWNode(int nTableIndex) {
        if (nTableIndex < 0 || nTableIndex > 4095) {
            throw new IllegalArgumentException("Illegal table index: " + nTableIndex);
        }
        this.m_nTableIndex = nTableIndex;
    }

    @Nonnegative
    public int getTableIndex() {
        if (this.m_nTableIndex < 0) {
            throw new IllegalStateException("This node has no table index!");
        }
        return this.m_nTableIndex;
    }

    public void setNode(@Nonnegative byte b, @Nonnull LZWNode aNode) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new LZWNode[256];
        }
        this.m_aChildren[b & 0xFF] = aNode;
    }

    @Nullable
    public LZWNode getChildNode(byte b) {
        return this.m_aChildren == null ? null : this.m_aChildren[b & 0xFF];
    }

    @Nullable
    public LZWNode getNode(byte[] aBuffer) {
        byte aByte;
        LZWNode aCurNode = this;
        byte[] arr$ = aBuffer;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (aCurNode = aCurNode.getChildNode(aByte = arr$[i$])) != null; ++i$) {
        }
        return aCurNode;
    }

    public String toString() {
        return new ToStringGenerator(null).append("index", this.m_nTableIndex).append("children#", ArrayHelper.getSize(this.m_aChildren)).toString();
    }
}

