/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ArrayEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private ELEMENTTYPE[] m_aArray;
    private int m_nIndex;

    public ArrayEnumeration(ELEMENTTYPE ... aArray) {
        this(aArray, 0, aArray.length);
    }

    public ArrayEnumeration(@Nonnull ELEMENTTYPE[] aArray, @Nonnegative int nStartIndex, @Nonnegative int nLength) {
        if (aArray == null) {
            throw new NullPointerException("array");
        }
        if (nStartIndex < 0) {
            throw new IllegalArgumentException("Start index may not be < 0: " + nStartIndex);
        }
        if (nLength < 0) {
            throw new IllegalArgumentException("Length may not be < 0: " + nLength);
        }
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(aArray, nStartIndex, nLength);
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_nIndex < this.m_aArray.length;
    }

    @Override
    @Nullable
    public ELEMENTTYPE nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ret = this.m_aArray[this.m_nIndex];
        ++this.m_nIndex;
        return ret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayEnumeration)) {
            return false;
        }
        ArrayEnumeration rhs = (ArrayEnumeration)o;
        return EqualsUtils.equals(this.m_aArray, rhs.m_aArray) && this.m_nIndex == rhs.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", this.m_aArray).append("index", this.m_nIndex).toString();
    }
}

