/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.compare.AbstractComparator;
import com.phloc.commons.compare.CollatorUtils;
import com.phloc.commons.compare.CompareUtils;
import com.phloc.commons.compare.ESortOrder;
import com.phloc.commons.string.ToStringGenerator;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCollationComparator<DATATYPE>
extends AbstractComparator<DATATYPE> {
    private final Collator m_aCollator;

    public AbstractCollationComparator() {
        this((Locale)null, ESortOrder.DEFAULT, (Comparator)null);
    }

    public AbstractCollationComparator(@Nullable Comparator<? super DATATYPE> aNestedComparator) {
        this((Locale)null, ESortOrder.DEFAULT, aNestedComparator);
    }

    public AbstractCollationComparator(@Nonnull ESortOrder eSortOrder) {
        this((Locale)null, eSortOrder, (Comparator)null);
    }

    public AbstractCollationComparator(@Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> aNestedComparator) {
        this((Locale)null, eSortOrder, aNestedComparator);
    }

    public AbstractCollationComparator(@Nullable Locale aSortLocale) {
        this(aSortLocale, ESortOrder.DEFAULT, (Comparator)null);
    }

    public AbstractCollationComparator(@Nullable Locale aSortLocale, @Nullable Comparator<? super DATATYPE> aNestedComparator) {
        this(aSortLocale, ESortOrder.DEFAULT, aNestedComparator);
    }

    public AbstractCollationComparator(@Nullable Locale aSortLocale, @Nonnull ESortOrder eSortOrder) {
        this(aSortLocale, eSortOrder, (Comparator)null);
    }

    public AbstractCollationComparator(@Nullable Locale aSortLocale, @Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> aNestedComparator) {
        super(eSortOrder, aNestedComparator);
        this.m_aCollator = CollatorUtils.getCollatorSpaceBeforeDot(aSortLocale);
    }

    public AbstractCollationComparator(@Nonnull Collator aCollator) {
        this(aCollator, ESortOrder.DEFAULT, (Comparator)null);
    }

    public AbstractCollationComparator(@Nonnull Collator aCollator, @Nullable Comparator<? super DATATYPE> aNestedComparator) {
        this(aCollator, ESortOrder.DEFAULT, aNestedComparator);
    }

    public AbstractCollationComparator(@Nonnull Collator aCollator, @Nonnull ESortOrder eSortOrder) {
        this(aCollator, eSortOrder, (Comparator)null);
    }

    public AbstractCollationComparator(@Nonnull Collator aCollator, @Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> aNestedComparator) {
        super(eSortOrder, aNestedComparator);
        if (aCollator == null) {
            throw new NullPointerException("collator");
        }
        this.m_aCollator = (Collator)aCollator.clone();
    }

    @Nullable
    protected abstract String asString(@Nonnull DATATYPE var1);

    @Nullable
    private String _nullSafeGetAsString(@Nullable DATATYPE aObject) {
        return aObject == null ? null : this.asString(aObject);
    }

    @Override
    protected final int mainCompare(@Nullable DATATYPE aElement1, @Nullable DATATYPE aElement2) {
        String s1 = this._nullSafeGetAsString(aElement1);
        String s2 = this._nullSafeGetAsString(aElement2);
        return CompareUtils.nullSafeCompare(s1, s2, this.m_aCollator);
    }

    public String toString() {
        return new ToStringGenerator(this).append("sortOrder", this.getSortOrder()).append("collator", this.m_aCollator).toString();
    }
}

