/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.concurrent;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.ToStringGenerator;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExtendedDefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger s_aPoolNumber = new AtomicInteger(1);
    private final ThreadGroup m_aThreadGroup;
    private final AtomicInteger m_aThreadNumber = new AtomicInteger(1);
    private final String m_sNamePrefix;

    public ExtendedDefaultThreadFactory() {
        this("threadpool");
    }

    public ExtendedDefaultThreadFactory(@Nonnull @Nonempty String sPoolPrefix) {
        SecurityManager aSecMgr = System.getSecurityManager();
        this.m_aThreadGroup = aSecMgr != null ? aSecMgr.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.m_sNamePrefix = sPoolPrefix + "[p" + s_aPoolNumber.getAndIncrement() + "-t";
    }

    @Override
    @Nonnull
    public Thread newThread(@Nonnull Runnable r) {
        String sThreadName = this.m_sNamePrefix + this.m_aThreadNumber.getAndIncrement() + ']';
        Thread aThread = new Thread(this.m_aThreadGroup, r, sThreadName, 0L);
        if (aThread.isDaemon()) {
            aThread.setDaemon(false);
        }
        if (aThread.getPriority() != 5) {
            aThread.setPriority(5);
        }
        return aThread;
    }

    public String toString() {
        return new ToStringGenerator(this).append("threadGroup", this.m_aThreadGroup).append("threadNumber", this.m_aThreadNumber).append("namePrefix", this.m_sNamePrefix).toString();
    }
}

