/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.concurrent.collector;

import com.phloc.commons.callback.IThrowingRunnableWithParameter;
import com.phloc.commons.concurrent.collector.AbstractConcurrentCollector;
import com.phloc.commons.lang.GenericReflection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectorMultiple<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    public static final int DEFAULT_MAX_PERFORM_COUNT = 50;
    private static final Logger s_aLogger = LoggerFactory.getLogger(ConcurrentCollectorMultiple.class);
    @Nonnegative
    private final int m_nMaxPerformCount;
    private IThrowingRunnableWithParameter<List<DATATYPE>> m_aPerformer;

    public ConcurrentCollectorMultiple() {
        this(null);
    }

    public ConcurrentCollectorMultiple(@Nullable IThrowingRunnableWithParameter<List<DATATYPE>> aPerformer) {
        this(100, 50, aPerformer);
    }

    public ConcurrentCollectorMultiple(@Nonnegative int nMaxQueueSize, @Nonnegative int nMaxPerformCount, @Nullable IThrowingRunnableWithParameter<List<DATATYPE>> aPerformer) {
        super(nMaxQueueSize);
        if (nMaxPerformCount > nMaxQueueSize || nMaxPerformCount < 1) {
            throw new IllegalArgumentException("max perform size is illegal: " + nMaxPerformCount);
        }
        this.m_nMaxPerformCount = nMaxPerformCount;
        if (aPerformer != null) {
            this.setPerformer(aPerformer);
        }
    }

    protected final void setPerformer(@Nonnull IThrowingRunnableWithParameter<List<DATATYPE>> aPerformer) {
        if (aPerformer == null) {
            throw new NullPointerException("performer");
        }
        this.m_aPerformer = aPerformer;
    }

    private void _executeCallback(@Nonnull List<DATATYPE> aObjectsToPerform) {
        if (!aObjectsToPerform.isEmpty()) {
            try {
                this.m_aPerformer.run(aObjectsToPerform);
            }
            catch (Throwable t) {
                s_aLogger.error("Failed to perform actions on " + aObjectsToPerform.size() + " objects - objects have been lost!", t);
            }
            aObjectsToPerform.clear();
        }
    }

    @Override
    public final void run() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object aCurrentObject;
            ArrayList aObjectsToPerform = new ArrayList();
            boolean bQueueIsStopped = false;
            while ((aCurrentObject = this.m_aQueue.take()) != STOP_QUEUE_OBJECT) {
                aObjectsToPerform.add(GenericReflection.uncheckedCast(aCurrentObject));
                while (aObjectsToPerform.size() < this.m_nMaxPerformCount && !this.m_aQueue.isEmpty()) {
                    aCurrentObject = this.m_aQueue.take();
                    if (aCurrentObject == STOP_QUEUE_OBJECT) {
                        bQueueIsStopped = true;
                        break;
                    }
                    aObjectsToPerform.add(GenericReflection.uncheckedCast(aCurrentObject));
                }
                this._executeCallback(aObjectsToPerform);
                if (!bQueueIsStopped) continue;
                break;
            }
            this._executeCallback(aObjectsToPerform);
        }
        catch (Throwable t) {
            s_aLogger.error("Error taking elements from queue - queue has been interrupted!!!", t);
        }
    }
}

