/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.io.streams.WrappedOutputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugOutputStream
extends WrappedOutputStream {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DebugOutputStream.class);
    private long m_nTotalBytesWritten = 0L;

    public DebugOutputStream(@Nonnull OutputStream aSourceOS) {
        super(aSourceOS);
    }

    @Nonnegative
    public final long getBytesWritten() {
        return this.m_nTotalBytesWritten;
    }

    @OverrideOnDemand
    protected void onWrite(@Nonnegative int nBytesWritten, long nTotalBytesWritten) {
        s_aLogger.info("Wrote " + nBytesWritten + " byte(s); now at " + nTotalBytesWritten);
    }

    @Override
    public final void write(int b) throws IOException {
        super.write(b);
        ++this.m_nTotalBytesWritten;
        this.onWrite(1, this.m_nTotalBytesWritten);
    }

    @Override
    public final void write(byte[] b, int nOffset, int nLength) throws IOException {
        super.write(b, nOffset, nLength);
        this.m_nTotalBytesWritten += (long)nLength;
        this.onWrite(nLength, this.m_nTotalBytesWritten);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("totalBytesWritten", this.m_nTotalBytesWritten).toString();
    }
}

