/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jaxb;

import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;

@Immutable
public final class JAXBMarshallerUtils {
    private static final String SUN_INDENT_STRING = "com.sun.xml.bind.indentString";
    private static final String SUN_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private static final String SUN_ENCODING_HANDLER2 = "com.sun.xml.bind.marshaller.CharacterEscapeHandler";
    private static final String SUN_XML_HEADERS = "com.sun.xml.bind.xmlHeaders";
    private static final String SUN_C14N = "com.sun.xml.bind.c14n";
    private static final String SUN_OBJECT_IDENTITY_CYCLE_DETECTION = "com.sun.xml.bind.objectIdentitityCycleDetection";

    private JAXBMarshallerUtils() {
    }

    private static void _setProperty(@Nonnull Marshaller aMarshaller, @Nonnull String sPropertyName, @Nullable Object aValue) {
        try {
            aMarshaller.setProperty(sPropertyName, aValue);
        }
        catch (PropertyException ex) {
            throw new IllegalArgumentException("Failed to set JAXB property '" + sPropertyName + "' to " + aValue, ex);
        }
    }

    @Nullable
    private static Object _getProperty(@Nonnull Marshaller aMarshaller, @Nonnull String sPropertyName) {
        try {
            return aMarshaller.getProperty(sPropertyName);
        }
        catch (PropertyException ex) {
            throw new IllegalArgumentException("Failed to get JAXB property '" + sPropertyName + "'", ex);
        }
    }

    private static boolean _getBooleanProperty(@Nonnull Marshaller aMarshaller, @Nonnull String sPropertyName) {
        return (Boolean)JAXBMarshallerUtils._getProperty(aMarshaller, sPropertyName);
    }

    private static String _getStringProperty(@Nonnull Marshaller aMarshaller, @Nonnull String sPropertyName) {
        return (String)JAXBMarshallerUtils._getProperty(aMarshaller, sPropertyName);
    }

    public static void setEncoding(@Nonnull Marshaller aMarshaller, @Nullable Charset aEncoding) {
        JAXBMarshallerUtils.setEncoding(aMarshaller, aEncoding == null ? null : aEncoding.name());
    }

    public static void setEncoding(@Nonnull Marshaller aMarshaller, @Nullable String sEncoding) {
        JAXBMarshallerUtils._setProperty(aMarshaller, "jaxb.encoding", sEncoding);
    }

    public static String getEncoding(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getStringProperty(aMarshaller, "jaxb.encoding");
    }

    public static void setFormattedOutput(@Nonnull Marshaller aMarshaller, boolean bFormattedOutput) {
        JAXBMarshallerUtils._setProperty(aMarshaller, "jaxb.formatted.output", bFormattedOutput);
    }

    public static boolean isFormattedOutput(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getBooleanProperty(aMarshaller, "jaxb.formatted.output");
    }

    public static void setSchemaLocation(@Nonnull Marshaller aMarshaller, @Nullable String sSchemaLocation) {
        JAXBMarshallerUtils._setProperty(aMarshaller, "jaxb.schemaLocation", sSchemaLocation);
    }

    public static String getSchemaLocation(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getStringProperty(aMarshaller, "jaxb.schemaLocation");
    }

    public static void setNoNamespaceSchemaLocation(@Nonnull Marshaller aMarshaller, @Nullable String sSchemaLocation) {
        JAXBMarshallerUtils._setProperty(aMarshaller, "jaxb.noNamespaceSchemaLocation", sSchemaLocation);
    }

    public static String getNoNamespaceSchemaLocation(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getStringProperty(aMarshaller, "jaxb.noNamespaceSchemaLocation");
    }

    public static void setFragment(@Nonnull Marshaller aMarshaller, boolean bFragment) {
        JAXBMarshallerUtils._setProperty(aMarshaller, "jaxb.fragment", bFragment);
    }

    public static boolean isFragment(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getBooleanProperty(aMarshaller, "jaxb.fragment");
    }

    public static void setSunIndentString(@Nonnull Marshaller aMarshaller, @Nullable String sIndentString) {
        JAXBMarshallerUtils._setProperty(aMarshaller, SUN_INDENT_STRING, sIndentString);
    }

    public static String getSunIndentString(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getStringProperty(aMarshaller, SUN_INDENT_STRING);
    }

    public static void setSunCharacterEscapeHandler(@Nonnull Marshaller aMarshaller, @Nonnull Object aCharacterEscapeHandler) {
        JAXBMarshallerUtils._setProperty(aMarshaller, SUN_ENCODING_HANDLER2, aCharacterEscapeHandler);
    }

    public static Object getSunCharacterEscapeHandler(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getProperty(aMarshaller, SUN_ENCODING_HANDLER2);
    }

    public static void setSunNamespacePrefixMapper(@Nonnull Marshaller aMarshaller, @Nonnull Object aNamespacePrefixMapper) {
        JAXBMarshallerUtils._setProperty(aMarshaller, SUN_PREFIX_MAPPER, aNamespacePrefixMapper);
    }

    public static Object getSunNamespacePrefixMapper(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getProperty(aMarshaller, SUN_PREFIX_MAPPER);
    }

    public static void setSunXMLHeaders(@Nonnull Marshaller aMarshaller, @Nonnull String sXMLHeaders) {
        JAXBMarshallerUtils._setProperty(aMarshaller, SUN_XML_HEADERS, sXMLHeaders);
    }

    public static String getSunXMLHeaders(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getStringProperty(aMarshaller, SUN_XML_HEADERS);
    }

    public static void setSunCanonicalization(@Nonnull Marshaller aMarshaller, boolean bCanonicalize) {
        JAXBMarshallerUtils._setProperty(aMarshaller, SUN_C14N, bCanonicalize);
    }

    public static boolean isSunCanonicalization(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getBooleanProperty(aMarshaller, SUN_C14N);
    }

    public static void setSunObjectIdentityCycleDetection(@Nonnull Marshaller aMarshaller, boolean bObjectIdentityCycleDetection) {
        JAXBMarshallerUtils._setProperty(aMarshaller, SUN_OBJECT_IDENTITY_CYCLE_DETECTION, bObjectIdentityCycleDetection);
    }

    public static boolean isSunObjectIdentityCycleDetection(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerUtils._getBooleanProperty(aMarshaller, SUN_OBJECT_IDENTITY_CYCLE_DETECTION);
    }

    public static boolean isSunJAXB2Marshaller(@Nullable Marshaller aMarshaller) {
        return aMarshaller != null && aMarshaller.getClass().getName().equals("com.sun.xml.bind.v2.runtime.MarshallerImpl");
    }
}

