/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.messagedigest;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.messagedigest.IMessageDigestGenerator;
import com.phloc.commons.messagedigest.MessageDigestGeneratorHelper;
import com.phloc.commons.string.StringHelper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public abstract class AbstractMessageDigestGenerator
implements IMessageDigestGenerator {
    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull String aValue, @Nonnull @Nonempty String sCharset) {
        if (aValue == null) {
            throw new NullPointerException("value");
        }
        if (StringHelper.hasNoText(sCharset)) {
            throw new IllegalArgumentException("charset");
        }
        return this.update(CharsetManager.getAsBytes(aValue, sCharset));
    }

    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull String aValue, @Nonnull Charset aCharset) {
        if (aValue == null) {
            throw new NullPointerException("value");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        return this.update(CharsetManager.getAsBytes(aValue, aCharset));
    }

    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull byte[] aValue) {
        if (aValue == null) {
            throw new NullPointerException("byteArray");
        }
        return this.update(aValue, 0, aValue.length);
    }

    @Override
    public final long getDigestLong() {
        return MessageDigestGeneratorHelper.getLongFromDigest(this.getDigest());
    }

    @Override
    @Nonnull
    public final String getDigestHexString() {
        return MessageDigestGeneratorHelper.getHexValueFromDigest(this.getDigest());
    }
}

