/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroProcessingInstruction;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroProcessingInstruction
extends AbstractMicroNode
implements IMicroProcessingInstruction {
    private final String m_sTarget;
    private final String m_sData;

    public MicroProcessingInstruction(@Nonnull @Nonempty String sTarget) {
        this(sTarget, null);
    }

    public MicroProcessingInstruction(@Nonnull @Nonempty String sTarget, @Nullable String sData) {
        if (StringHelper.hasNoText(sTarget)) {
            throw new IllegalArgumentException("The passed target is valid");
        }
        this.m_sTarget = sTarget;
        this.m_sData = sData;
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.PROCESSING_INSTRUCTION;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return "#pi";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeValue() {
        return this.m_sTarget;
    }

    @Override
    public String getTarget() {
        return this.m_sTarget;
    }

    @Override
    public String getData() {
        return this.m_sData;
    }

    @Override
    @Nonnull
    public IMicroProcessingInstruction getClone() {
        return new MicroProcessingInstruction(this.m_sTarget, this.m_sData);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroProcessingInstruction)) {
            return false;
        }
        MicroProcessingInstruction rhs = (MicroProcessingInstruction)o;
        return this.m_sTarget.equals(rhs.m_sTarget) && EqualsUtils.equals(this.m_sData, rhs.m_sData);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("target", this.m_sTarget).append("data", this.m_sData).toString();
    }
}

