/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.walk;

import com.phloc.commons.hierarchy.IHierarchyWalkerCallback;
import com.phloc.commons.parent.IChildrenProvider;
import com.phloc.commons.parent.impl.ChildrenProviderHasChildren;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.IBasicTreeItem;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWalker {
    private static final TreeWalker s_aInstance = new TreeWalker();

    private TreeWalker() {
    }

    private static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void _walkTree(@Nonnull ITEMTYPE aTreeItem, @Nonnull IChildrenProvider<ITEMTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> aCallback) {
        aCallback.onItemBeforeChildren(aTreeItem);
        if (aChildrenProvider.hasChildren(aTreeItem)) {
            for (IBasicTreeItem aChildItem : aChildrenProvider.getChildren(aTreeItem)) {
                aCallback.onLevelDown();
                TreeWalker._walkTree(aChildItem, aChildrenProvider, aCallback);
                aCallback.onLevelUp();
            }
        }
        aCallback.onItemAfterChildren(aTreeItem);
    }

    public static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void walkTree(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> aCallback) {
        TreeWalker.walkTree(aTree, new ChildrenProviderHasChildren(), aCallback);
    }

    public static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void walkTree(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull IChildrenProvider<ITEMTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> aCallback) {
        if (aTree == null) {
            throw new NullPointerException("tree");
        }
        TreeWalker.walkSubTree(aTree.getRootItem(), aChildrenProvider, aCallback);
    }

    public static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void walkSubTree(@Nonnull ITEMTYPE aTreeItem, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> aCallback) {
        TreeWalker.walkSubTree(aTreeItem, new ChildrenProviderHasChildren(), aCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <VALUETYPE, ITEMTYPE extends IBasicTreeItem<VALUETYPE, ITEMTYPE>> void walkSubTree(@Nonnull ITEMTYPE aTreeItem, @Nonnull IChildrenProvider<ITEMTYPE> aChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> aCallback) {
        if (aTreeItem == null) {
            throw new NullPointerException("treeItem");
        }
        if (aChildrenProvider == null) {
            throw new NullPointerException("childrenProvider");
        }
        if (aCallback == null) {
            throw new NullPointerException("callback");
        }
        aCallback.begin();
        try {
            if (aChildrenProvider.hasChildren(aTreeItem)) {
                for (IBasicTreeItem aChildItem : aChildrenProvider.getChildren(aTreeItem)) {
                    TreeWalker._walkTree(aChildItem, aChildrenProvider, aCallback);
                }
            }
        }
        finally {
            aCallback.end();
        }
    }
}

