/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.type;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.type.ITypedObject;
import com.phloc.commons.type.ObjectType;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TypedObject<IDTYPE>
implements ITypedObject<IDTYPE>,
Serializable {
    private final ObjectType m_aTypeID;
    private final IDTYPE m_aID;

    public TypedObject(@Nonnull ITypedObject<IDTYPE> aObj) {
        this(aObj.getTypeID(), aObj.getID());
    }

    public TypedObject(@Nonnull ObjectType aTypeID, @Nonnull IDTYPE aID) {
        if (aTypeID == null) {
            throw new NullPointerException("type");
        }
        if (aID == null) {
            throw new NullPointerException("id");
        }
        this.m_aTypeID = aTypeID;
        this.m_aID = aID;
    }

    @Override
    @Nonnull
    public ObjectType getTypeID() {
        return this.m_aTypeID;
    }

    @Override
    @Nonnull
    public IDTYPE getID() {
        return this.m_aID;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypedObject)) {
            return false;
        }
        TypedObject rhs = (TypedObject)o;
        return this.m_aTypeID.equals(rhs.m_aTypeID) && this.m_aID.equals(rhs.m_aID);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aTypeID).append(this.m_aID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("type", this.m_aTypeID).append("id", this.m_aID).toString();
    }

    @Nonnull
    public static <IDTYPE> TypedObject<IDTYPE> create(@Nonnull ITypedObject<IDTYPE> aObj) {
        return new TypedObject<IDTYPE>(aObj);
    }

    @Nonnull
    public static <IDTYPE> TypedObject<IDTYPE> create(@Nonnull ObjectType aTypeID, @Nonnull IDTYPE aID) {
        return new TypedObject<IDTYPE>(aTypeID, aID);
    }
}

