/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.namespace;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.multimap.IMultiMapSetBased;
import com.phloc.commons.collections.multimap.MultiHashMapHashSetBased;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.namespace.AbstractNamespaceContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MapBasedNamespaceContext
extends AbstractNamespaceContext {
    private String m_sDefaultNamespaceURI;
    private final Map<String, String> m_aPrefix2NS = new HashMap<String, String>();
    private final IMultiMapSetBased<String, String> m_aNS2Prefix = new MultiHashMapHashSetBased<String, String>();

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sDefaultNamespaceURI;
    }

    @Nonnull
    public MapBasedNamespaceContext addMapping(@Nonnull String sPrefix, @Nonnull @Nonempty String sNamespaceURI) {
        if (sPrefix == null) {
            throw new IllegalArgumentException("prefix may not be empty");
        }
        if (StringHelper.hasNoText(sNamespaceURI)) {
            throw new IllegalArgumentException("namespaceURI may not be empty");
        }
        if (this.m_aPrefix2NS.containsKey(sPrefix)) {
            throw new IllegalArgumentException("The prefix '" + sPrefix + "' is already registered!");
        }
        if (sPrefix.equals("")) {
            this.m_sDefaultNamespaceURI = sNamespaceURI;
        }
        this.m_aPrefix2NS.put(sPrefix, sNamespaceURI);
        this.m_aNS2Prefix.putSingle(sNamespaceURI, sPrefix);
        return this;
    }

    @Override
    @Nullable
    protected Iterator<String> getCustomPrefixes(@Nonnull String sNamespaceURI) {
        Set aAllPrefixes = (Set)this.m_aNS2Prefix.get(sNamespaceURI);
        return aAllPrefixes == null ? null : aAllPrefixes.iterator();
    }

    @Override
    @Nullable
    protected String getCustomPrefix(@Nonnull String sNamespaceURI) {
        Set aAllPrefixes = (Set)this.m_aNS2Prefix.get(sNamespaceURI);
        return aAllPrefixes == null || aAllPrefixes.isEmpty() ? null : (String)aAllPrefixes.iterator().next();
    }

    @Override
    @Nullable
    protected String getCustomNamespaceURI(@Nonnull String sPrefix) {
        return this.m_aPrefix2NS.get(sPrefix);
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("defaultNS", this.m_sDefaultNamespaceURI).append("prefix2NS", this.m_aPrefix2NS).append("ns2Prefix2", this.m_aNS2Prefix).toString();
    }
}

