/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.io.streams.NonBlockingBufferedWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.serialize.IXMLSerializer;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializerPhloc<NODETYPE>
implements IXMLSerializer<NODETYPE> {
    protected static final String NEWLINE = CGlobal.LINE_SEPARATOR;
    protected static final String INDENT = "  ";
    protected final IXMLWriterSettings m_aSettings;
    protected final StringBuilder m_aIndent = new StringBuilder(32);
    protected final NamespaceStack m_aNSStack;

    public AbstractSerializerPhloc(@Nonnull IXMLWriterSettings aSettings) {
        if (aSettings == null) {
            throw new NullPointerException("settings");
        }
        this.m_aSettings = aSettings;
        this.m_aNSStack = new NamespaceStack(aSettings.getNamespaceContext());
    }

    @Nonnull
    public final IXMLWriterSettings getSettings() {
        return this.m_aSettings;
    }

    @Override
    public final void write(@Nonnull NODETYPE aNode, @Nonnull @WillNotClose OutputStream aOS) {
        NonBlockingBufferedWriter aWriter = new NonBlockingBufferedWriter(StreamUtils.createWriter(aOS, this.m_aSettings.getCharsetObj()));
        this.write(aNode, aWriter);
    }

    public String toString() {
        return new ToStringGenerator(this).append("settings", this.m_aSettings).append("sIndent", this.m_aIndent.toString()).append("namespaceStack", this.m_aNSStack).toString();
    }

    protected static final class NamespaceStack {
        private final List<NamespaceLevel> m_aStack = new ArrayList<NamespaceLevel>();
        private final NamespaceContext m_aNamespaceCtx;

        public NamespaceStack(@Nullable NamespaceContext aNamespaceCtx) {
            this.m_aNamespaceCtx = aNamespaceCtx;
        }

        public void push(@Nullable Map<String, String> aAttrs) {
            NamespaceLevel aNSL = new NamespaceLevel(aAttrs);
            this.m_aStack.add(0, aNSL);
        }

        public void addNamespaceMapping(String sPrefix, String sNamespace) {
            ContainerHelper.getFirstElement(this.m_aStack).addPrefixNamespaceMapping(sPrefix, sNamespace);
        }

        public void pop() {
            this.m_aStack.remove(0);
        }

        @Nullable
        public String getDefaultNamespace() {
            for (NamespaceLevel aNSLevel : this.m_aStack) {
                if (aNSLevel.getDefaultNamespaceURI() == null) continue;
                return aNSLevel.getDefaultNamespaceURI();
            }
            return null;
        }

        @Nullable
        public String findPrefix(@Nullable String sNamespace) {
            if (StringHelper.hasNoText(sNamespace)) {
                return null;
            }
            if (sNamespace.equals(this.getDefaultNamespace())) {
                return null;
            }
            for (NamespaceLevel aNSLevel : this.m_aStack) {
                String sPrefix = aNSLevel.getPrefixOfNamespace(sNamespace);
                if (sPrefix == null) continue;
                return sPrefix;
            }
            return null;
        }

        private boolean _containsAnyNamespace() {
            for (NamespaceLevel aNSLevel : this.m_aStack) {
                if (aNSLevel.getNamespaceCount() <= 0) continue;
                return true;
            }
            return false;
        }

        private boolean _containsPrefix(@Nonnull String sPrefix) {
            for (NamespaceLevel aNSLevel : this.m_aStack) {
                if (aNSLevel.getNamespaceOfPrefix(sPrefix) == null) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public String createUniquePrefix(@Nonnull @Nonempty String sElementNamespaceURI) {
            String sPrefix;
            if (this.m_aNamespaceCtx != null && (sPrefix = this.m_aNamespaceCtx.getPrefix(sElementNamespaceURI)) != null) {
                return sPrefix;
            }
            if (!this._containsAnyNamespace()) {
                return null;
            }
            int nCount = 0;
            while (this._containsPrefix("ns" + nCount)) {
                ++nCount;
            }
            return "ns" + nCount;
        }
    }

    protected static final class NamespaceLevel {
        private static final Logger s_aLogger = LoggerFactory.getLogger(NamespaceLevel.class);
        private String m_sDefaultNamespaceURI;
        private Map<String, String> m_aURL2PrefixMap;

        public NamespaceLevel(@Nullable Map<String, String> aAttrs) {
            if (aAttrs != null) {
                for (Map.Entry<String, String> aEntry : aAttrs.entrySet()) {
                    String sAttrName = aEntry.getKey();
                    if (sAttrName.equals("xmlns")) {
                        this.addPrefixNamespaceMapping(null, aEntry.getValue());
                        continue;
                    }
                    if (!sAttrName.startsWith("xmlns:")) continue;
                    this.addPrefixNamespaceMapping(sAttrName.substring("xmlns:".length()), aEntry.getValue());
                }
            }
        }

        @Nullable
        public String getNamespaceOfPrefix(@Nullable String sPrefix) {
            if (StringHelper.hasNoText(sPrefix)) {
                return this.m_sDefaultNamespaceURI;
            }
            if (this.m_aURL2PrefixMap != null) {
                for (Map.Entry<String, String> aEntry : this.m_aURL2PrefixMap.entrySet()) {
                    if (!aEntry.getValue().equals(sPrefix)) continue;
                    return aEntry.getKey();
                }
            }
            return null;
        }

        void addPrefixNamespaceMapping(@Nullable String sPrefix, @Nonnull @Nonempty String sNamespace) {
            String sExistingURI;
            if (s_aLogger.isTraceEnabled()) {
                s_aLogger.trace("Adding namespace mapping " + sPrefix + ":" + sNamespace);
            }
            if ((sExistingURI = this.getNamespaceOfPrefix(sPrefix)) != null && !sExistingURI.equals(sNamespace)) {
                s_aLogger.warn("Overwriting namespace prefix '" + sPrefix + "' to use URL '" + sNamespace + "' instead of '" + sExistingURI + "'");
            }
            if (StringHelper.hasNoText(sPrefix)) {
                this.m_sDefaultNamespaceURI = sNamespace;
            } else {
                if (this.m_aURL2PrefixMap == null) {
                    this.m_aURL2PrefixMap = new HashMap<String, String>();
                }
                this.m_aURL2PrefixMap.put(sNamespace, sPrefix);
            }
        }

        @Nullable
        public String getDefaultNamespaceURI() {
            return this.m_sDefaultNamespaceURI;
        }

        @Nullable
        public String getPrefixOfNamespace(@Nullable String sNamespace) {
            if (this.m_sDefaultNamespaceURI != null && this.m_sDefaultNamespaceURI.equals(sNamespace)) {
                return null;
            }
            return this.m_aURL2PrefixMap == null ? null : this.m_aURL2PrefixMap.get(sNamespace);
        }

        @Nonnegative
        int getNamespaceCount() {
            return (this.m_aURL2PrefixMap == null ? 0 : this.m_aURL2PrefixMap.size()) + (this.m_sDefaultNamespaceURI == null ? 0 : 1);
        }

        public String toString() {
            return new ToStringGenerator(this).append("defaultNSURL", this.m_sDefaultNamespaceURI).append("url2prefix", this.m_aURL2PrefixMap).toString();
        }
    }
}

