/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamSource;

@NotThreadSafe
public final class ResourceStreamSource
extends StreamSource {
    private final IInputStreamProvider m_aISP;

    public ResourceStreamSource(@Nonnull IReadableResource aResource) {
        this(aResource, aResource.getResourceID());
    }

    public ResourceStreamSource(@Nonnull IInputStreamProvider aISP, @Nullable String sSystemID) {
        if (aISP == null) {
            throw new NullPointerException("resource");
        }
        this.m_aISP = aISP;
        this.setSystemId(sSystemID);
    }

    @Override
    public InputStream getInputStream() {
        InputStream aIS = this.m_aISP.getInputStream();
        if (aIS == null) {
            throw new IllegalStateException("Failed to open input stream for " + this.m_aISP);
        }
        return aIS;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).append("systemID", this.getSystemId()).toString();
    }
}

