/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSExpressionMathMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionMemberMathProduct
implements ICSSExpressionMathMember {
    private final List<ICSSExpressionMathMember> m_aMembers = new ArrayList<ICSSExpressionMathMember>();

    public void addMember(@Nonnull ICSSExpressionMathMember aMember) {
        if (aMember == null) {
            throw new NullPointerException("member");
        }
        this.m_aMembers.add(aMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSExpressionMathMember aMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(aMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nMemberIndex) {
        if (nMemberIndex < 0 || nMemberIndex >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(nMemberIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSExpressionMathMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        StringBuilder aSB = new StringBuilder();
        for (ICSSExpressionMathMember aMember : this.m_aMembers) {
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSExpressionMemberMathProduct)) {
            return false;
        }
        CSSExpressionMemberMathProduct rhs = (CSSExpressionMemberMathProduct)o;
        return ((Object)this.m_aMembers).equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).toString();
    }
}

