/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSHSLA
implements ICSSWriteable {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;
    private String m_sOpacity;

    public CSSHSLA(int nHue, int nSaturation, int nLightness, float fOpacity) {
        this(Integer.toString(CSSColorHelper.getRGBValue(nHue)), Integer.toString(CSSColorHelper.getRGBValue(nSaturation)), Integer.toString(CSSColorHelper.getRGBValue(nLightness)), Float.toString(CSSColorHelper.getOpacityToUse(fOpacity)));
    }

    public CSSHSLA(@Nonnull @Nonempty String sHue, @Nonnull @Nonempty String sSaturation, @Nonnull @Nonempty String sLightness, @Nonnull @Nonempty String sOpacity) {
        this.setHue(sHue);
        this.setSaturation(sSaturation);
        this.setLightness(sLightness);
        this.setOpacity(sOpacity);
    }

    @Nonnull
    @Nonempty
    public String getHue() {
        return this.m_sHue;
    }

    public void setHue(@Nonnull @Nonempty String sHue) {
        if (StringHelper.hasNoText((CharSequence)sHue)) {
            throw new IllegalArgumentException("hue");
        }
        this.m_sHue = sHue;
    }

    @Nonnull
    @Nonempty
    public String getSaturation() {
        return this.m_sSaturation;
    }

    public void setSaturation(@Nonnull @Nonempty String sSaturation) {
        if (StringHelper.hasNoText((CharSequence)sSaturation)) {
            throw new IllegalArgumentException("saturation");
        }
        this.m_sSaturation = sSaturation;
    }

    @Nonnull
    @Nonempty
    public String getLightness() {
        return this.m_sLightness;
    }

    public void setLightness(@Nonnull @Nonempty String sLightness) {
        if (StringHelper.hasNoText((CharSequence)sLightness)) {
            throw new IllegalArgumentException("lightness");
        }
        this.m_sLightness = sLightness;
    }

    @Nonnull
    @Nonempty
    public String getOpacity() {
        return this.m_sOpacity;
    }

    public void setOpacity(@Nonnull @Nonempty String sOpacity) {
        if (StringHelper.hasNoText((CharSequence)sOpacity)) {
            throw new IllegalArgumentException("opacity");
        }
        this.m_sOpacity = sOpacity;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return "hsla(" + this.m_sHue + ',' + this.m_sSaturation + ',' + this.m_sLightness + ',' + this.m_sOpacity + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSHSLA)) {
            return false;
        }
        CSSHSLA rhs = (CSSHSLA)o;
        return this.m_sHue.equals(rhs.m_sHue) && this.m_sSaturation.equals(rhs.m_sSaturation) && this.m_sLightness.equals(rhs.m_sLightness) && this.m_sOpacity.equals(rhs.m_sOpacity);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sHue).append((Object)this.m_sSaturation).append((Object)this.m_sLightness).append((Object)this.m_sOpacity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hue", (Object)this.m_sHue).append("saturation", (Object)this.m_sSaturation).append("lightness", (Object)this.m_sLightness).append("opacity", (Object)this.m_sOpacity).toString();
    }
}

