/*
 * Decompiled with CFR 0.152.
 */
package com.schematron.ant;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SVRLHandler
extends DefaultHandler {
    private static final String FAILED_ASSERT_ELT = "svrl:failed-assert";
    private static final String TEXT_ELT = "svrl:text";
    private static final String SUCCESSFUL_REPORT_ELT = "svrl:successful-report";
    private static final String TEST_ATT = "test";
    private static final String LOCATION_ATT = "location";
    private StringBuffer chars = new StringBuffer();
    private StringBuffer message = new StringBuffer();
    private String lastElement;
    private ArrayList<String> failedAssertions;
    private ArrayList<String> successfulReports;
    private boolean underAssertorReport = false;

    public SVRLHandler() {
    }

    public SVRLHandler(ArrayList<String> failedAssertions, ArrayList<String> successfulReports) {
        this.failedAssertions = failedAssertions;
        this.successfulReports = successfulReports;
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        if (rawName.equals(FAILED_ASSERT_ELT)) {
            this.message.append("[assert] " + attributes.getValue(LOCATION_ATT));
            this.lastElement = FAILED_ASSERT_ELT;
            this.underAssertorReport = true;
        } else if (rawName.equals(SUCCESSFUL_REPORT_ELT)) {
            this.message.append("[report] " + attributes.getValue(LOCATION_ATT));
            this.lastElement = SUCCESSFUL_REPORT_ELT;
            this.underAssertorReport = true;
        } else if (rawName.equals(TEXT_ELT) && this.underAssertorReport) {
            this.getCharacters();
        }
    }

    @Override
    public void endElement(String namespaceURL, String localName, String rawName) {
        if (rawName.equals(TEXT_ELT) && this.underAssertorReport) {
            this.message.append(" - " + this.getCharacters());
            if (this.lastElement.equals(FAILED_ASSERT_ELT)) {
                this.failedAssertions.add(this.getMessage());
            } else {
                this.successfulReports.add(this.getMessage());
            }
            this.underAssertorReport = false;
        }
        this.lastElement = "";
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.chars.append(ch, start, length);
    }

    private String getCharacters() {
        String retstr = this.chars.toString();
        this.chars.setLength(0);
        return retstr;
    }

    private String getMessage() {
        String retstr = this.message.toString();
        this.message.setLength(0);
        return retstr;
    }
}

