/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SingleElementEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private boolean m_bHasMoreElements = true;
    private final ELEMENTTYPE m_aElement;

    public SingleElementEnumeration(@Nullable ELEMENTTYPE aElement) {
        this.m_aElement = aElement;
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_bHasMoreElements;
    }

    @Override
    @Nullable
    public ELEMENTTYPE nextElement() {
        if (this.m_bHasMoreElements) {
            this.m_bHasMoreElements = false;
            return this.m_aElement;
        }
        throw new NoSuchElementException();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleElementEnumeration)) {
            return false;
        }
        SingleElementEnumeration rhs = (SingleElementEnumeration)o;
        return this.m_bHasMoreElements == rhs.m_bHasMoreElements && EqualsUtils.equals(this.m_aElement, rhs.m_aElement);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasMoreElements).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasMoreElements", this.m_bHasMoreElements).append("element", this.m_aElement).toString();
    }

    @Nonnull
    public static <T> Enumeration<T> create(@Nullable T aElement) {
        return new SingleElementEnumeration<T>(aElement);
    }
}

