/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TimeValue {
    public static final TimeValue SEC1 = new TimeValue(TimeUnit.SECONDS, 1L);
    private final TimeUnit m_eTimeUnit;
    private final long m_nDuration;

    public TimeValue(@Nonnull TimeUnit eTimeUnit, long nDuration) {
        if (eTimeUnit == null) {
            throw new NullPointerException("timeUnit");
        }
        this.m_eTimeUnit = eTimeUnit;
        this.m_nDuration = nDuration;
    }

    @Nonnull
    public TimeUnit getTimeUnit() {
        return this.m_eTimeUnit;
    }

    public long getDuration() {
        return this.m_nDuration;
    }

    public long getAsNanos() {
        return this.m_eTimeUnit.toNanos(this.m_nDuration);
    }

    public long getAsMicros() {
        return this.m_eTimeUnit.toMicros(this.m_nDuration);
    }

    public long getAsMillis() {
        return this.m_eTimeUnit.toMillis(this.m_nDuration);
    }

    public long getAsSeconds() {
        return this.m_eTimeUnit.toSeconds(this.m_nDuration);
    }

    public long getAsMinutes() {
        return this.m_eTimeUnit.toMinutes(this.m_nDuration);
    }

    public long getAsHours() {
        return this.m_eTimeUnit.toHours(this.m_nDuration);
    }

    public long getAsDays() {
        return this.m_eTimeUnit.toDays(this.m_nDuration);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeValue)) {
            return false;
        }
        TimeValue rhs = (TimeValue)o;
        return this.m_eTimeUnit.equals((Object)rhs.m_eTimeUnit) && this.m_nDuration == rhs.m_nDuration;
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eTimeUnit)).append(this.m_nDuration).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("timeUnit", this.m_eTimeUnit).append("value", this.m_nDuration).toString();
    }
}

