/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSRect
implements ICSSWriteable {
    private String m_sTop;
    private String m_sRight;
    private String m_sBottom;
    private String m_sLeft;

    public CSSRect(@Nonnull @Nonempty String sTop, @Nonnull @Nonempty String sRight, @Nonnull @Nonempty String sBottom, @Nonnull @Nonempty String sLeft) {
        this.setTop(sTop);
        this.setRight(sRight);
        this.setBottom(sBottom);
        this.setLeft(sLeft);
    }

    @Nonnull
    @Nonempty
    public String getTop() {
        return this.m_sTop;
    }

    public void setTop(@Nonnull @Nonempty String sTop) {
        if (StringHelper.hasNoText((CharSequence)sTop)) {
            throw new IllegalArgumentException("top");
        }
        this.m_sTop = sTop;
    }

    @Nonnull
    @Nonempty
    public String getRight() {
        return this.m_sRight;
    }

    public void setRight(@Nonnull @Nonempty String sRight) {
        if (StringHelper.hasNoText((CharSequence)sRight)) {
            throw new IllegalArgumentException("right");
        }
        this.m_sRight = sRight;
    }

    @Nonnull
    @Nonempty
    public String getBottom() {
        return this.m_sBottom;
    }

    public void setBottom(@Nonnull @Nonempty String sBottom) {
        if (StringHelper.hasNoText((CharSequence)sBottom)) {
            throw new IllegalArgumentException("bottom");
        }
        this.m_sBottom = sBottom;
    }

    @Nonnull
    @Nonempty
    public String getLeft() {
        return this.m_sLeft;
    }

    public void setLeft(@Nonnull @Nonempty String sLeft) {
        if (StringHelper.hasNoText((CharSequence)sLeft)) {
            throw new IllegalArgumentException("left");
        }
        this.m_sLeft = sLeft;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return "rect(" + this.m_sTop + ' ' + this.m_sRight + ' ' + this.m_sBottom + ' ' + this.m_sLeft + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSRect)) {
            return false;
        }
        CSSRect rhs = (CSSRect)o;
        return this.m_sTop.equals(rhs.m_sTop) && this.m_sRight.equals(rhs.m_sRight) && this.m_sBottom.equals(rhs.m_sBottom) && this.m_sLeft.equals(rhs.m_sLeft);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sTop).append((Object)this.m_sRight).append((Object)this.m_sBottom).append((Object)this.m_sLeft).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("top", (Object)this.m_sTop).append("right", (Object)this.m_sRight).append("bottom", (Object)this.m_sBottom).append("left", (Object)this.m_sLeft).toString();
    }
}

