/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.om.AbstractItem;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleArrayItem
extends AbstractItem
implements ArrayItem {
    public static final SimpleArrayItem EMPTY_ARRAY = new SimpleArrayItem(new ArrayList<Sequence>());
    private List<Sequence> members;
    private boolean knownToBeGrounded = false;
    private SequenceType memberType = null;

    public SimpleArrayItem(List<Sequence> members) {
        this.members = members;
    }

    public static SimpleArrayItem makeSimpleArrayItem(SequenceIterator input) throws XPathException {
        Item item;
        ArrayList<Sequence> members = new ArrayList<Sequence>();
        while ((item = input.next()) != null) {
            if (item.getClass().getName().equals("com.saxonica.functions.extfn.ArrayMemberValue")) {
                members.add((Sequence)((ObjectValue)item).getObject());
                continue;
            }
            members.add(item);
        }
        SimpleArrayItem result = new SimpleArrayItem(members);
        result.knownToBeGrounded = true;
        return result;
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeGrounded() throws XPathException {
        if (!this.knownToBeGrounded) {
            SimpleArrayItem simpleArrayItem = this;
            synchronized (simpleArrayItem) {
                for (int i = 0; i < this.members.size(); ++i) {
                    if (this.members.get(i) instanceof GroundedValue) continue;
                    this.members.set(i, SequenceTool.toGroundedValue(this.members.get(i)));
                }
                this.knownToBeGrounded = true;
            }
        }
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        this.makeGrounded();
        ArrayList<AtomicValue> list = new ArrayList<AtomicValue>(this.members.size());
        for (Sequence seq : this.members) {
            Item item;
            SequenceIterator iter = seq.iterate();
            while ((item = iter.next()) != null) {
                AtomicSequence atoms = item.atomize();
                for (AtomicValue atom : atoms) {
                    list.add(atom);
                }
            }
        }
        return new AtomicArray(list);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    public Sequence get(int index) throws XPathException {
        if (index < 0 || index >= this.members.size()) {
            throw new XPathException("Array index (" + (index + 1) + ") out of range (1 to " + this.members.size() + ")", "FOAY0001");
        }
        return this.members.get(index);
    }

    @Override
    public ArrayItem put(int index, Sequence newValue) throws XPathException {
        ArrayList<Sequence> newList = new ArrayList<Sequence>(this.members.size());
        newList.addAll(this.members);
        if (index < 0 || index >= this.members.size()) {
            if (this.members.size() == 0) {
                throw new XPathException("Array is empty", "FOAY0001");
            }
            throw new XPathException("Array index (" + (index + 1) + ") out of range (1 to " + this.members.size() + ")", "FOAY0001");
        }
        newList.set(index, newValue);
        SimpleArrayItem result = new SimpleArrayItem(newList);
        if (this.knownToBeGrounded && newValue instanceof GroundedValue) {
            result.knownToBeGrounded = true;
        }
        return result;
    }

    @Override
    public int arrayLength() {
        return this.members.size();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public Iterator<Sequence> iterator() {
        return this.members.iterator();
    }

    @Override
    public ArrayItem removeSeveral(IntSet positions) {
        ArrayList<Sequence> newList = new ArrayList<Sequence>(this.members.size() - 1);
        for (int i = 0; i < this.members.size(); ++i) {
            if (positions.contains(i)) continue;
            newList.add(this.members.get(i));
        }
        SimpleArrayItem result = new SimpleArrayItem(newList);
        if (this.knownToBeGrounded) {
            result.knownToBeGrounded = true;
        }
        result.memberType = this.memberType;
        return result;
    }

    @Override
    public ArrayItem remove(int pos) {
        ArrayList<Sequence> newList = new ArrayList<Sequence>(this.members.size() - 1);
        newList.addAll(this.members.subList(0, pos));
        newList.addAll(this.members.subList(pos + 1, this.members.size()));
        SimpleArrayItem result = new SimpleArrayItem(newList);
        if (this.knownToBeGrounded) {
            result.knownToBeGrounded = true;
        }
        result.memberType = this.memberType;
        return result;
    }

    @Override
    public ArrayItem concat(ArrayItem other) {
        ArrayList<Sequence> newList = new ArrayList<Sequence>(this.members.size() + other.arrayLength());
        newList.addAll(this.members);
        for (Sequence s : other) {
            newList.add(s);
        }
        SimpleArrayItem result = new SimpleArrayItem(newList);
        if (other instanceof SimpleArrayItem) {
            if (this.knownToBeGrounded && ((SimpleArrayItem)other).knownToBeGrounded) {
                result.knownToBeGrounded = true;
            }
            if (this.memberType != null && this.memberType.equals(((SimpleArrayItem)other).memberType)) {
                result.memberType = this.memberType;
            }
        }
        return result;
    }

    @Override
    public SequenceType getMemberType(TypeHierarchy th) {
        try {
            this.makeGrounded();
            if (this.memberType == null) {
                if (this.members.isEmpty()) {
                    this.memberType = SequenceType.makeSequenceType(ErrorType.getInstance(), 16384);
                } else {
                    ItemType contentType = null;
                    int contentCard = 16384;
                    for (Sequence s : this.members) {
                        if (contentType == null) {
                            contentType = SequenceTool.getItemType(s, th);
                            contentCard = SequenceTool.getCardinality(s);
                            continue;
                        }
                        contentType = Type.getCommonSuperType(contentType, SequenceTool.getItemType(s, th));
                        contentCard = Cardinality.union(contentCard, SequenceTool.getCardinality(s));
                    }
                    this.memberType = SequenceType.makeSequenceType(contentType, contentCard);
                }
            }
            return this.memberType;
        }
        catch (XPathException e) {
            return SequenceType.ANY_SEQUENCE;
        }
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        return ArrayItemType.ANY_ARRAY_TYPE;
    }

    @Override
    public StructuredQName getFunctionName() {
        return null;
    }

    @Override
    public String getDescription() {
        return "array";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        return this.get((int)((IntegerValue)args[0].head()).longValue() - 1);
    }

    @Override
    public boolean deepEquals(Function other, XPathContext context, AtomicComparer comparer, int flags) throws XPathException {
        if (other instanceof ArrayItem) {
            ArrayItem that = (ArrayItem)other;
            if (this.arrayLength() != that.arrayLength()) {
                return false;
            }
            for (int i = 0; i < this.arrayLength(); ++i) {
                if (DeepEqual.deepEqual(this.get(i).iterate(), that.get(i).iterate(), comparer, context, flags)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("Effective boolean value is not defined for arrays", "FORG0006");
    }

    @Override
    public String getStringValue() {
        throw new UnsupportedOperationException("An array does not have a string value");
    }

    @Override
    public CharSequence getStringValueCS() {
        throw new UnsupportedOperationException("An array does not have a string value");
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("array");
        out.emitAttribute("size", this.arrayLength() + "");
        for (Sequence mem : this.members) {
            Literal.exportValue(mem, out);
        }
        out.endElement();
    }

    @Override
    public boolean isTrustedResultType() {
        return false;
    }

    @Override
    public List<Sequence> getMembers() {
        return this.members;
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer(256);
        buffer.append("[");
        for (Sequence seq : this.members) {
            if (buffer.length() > 1) {
                buffer.append(", ");
            }
            buffer.append(seq.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

