/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.nrl.NrlProperty;
import com.thaiopensource.validate.nrl.SchemaImpl;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.SAXSchemaReader;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private static final String NRL_SCHEMA = "nrl.rng";
    private static final String RNC_MEDIA_TYPE = "application/x-rnc";
    private final PropertyMap properties;
    private final boolean attributesSchema;
    private final SchemaReader autoSchemaReader;
    private Schema nrlSchema = null;
    private static final PropertyId[] subSchemaProperties = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, ValidateProperty.ENTITY_RESOLVER, SchemaReceiverFactory.PROPERTY};

    public SchemaReceiverImpl(PropertyMap propertyMap) {
        this.attributesSchema = propertyMap.contains(NrlProperty.ATTRIBUTES_SCHEMA);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        for (int i = 0; i < subSchemaProperties.length; ++i) {
            Object object = propertyMap.get(subSchemaProperties[i]);
            if (object == null) continue;
            propertyMapBuilder.put(subSchemaProperties[i], object);
        }
        this.properties = propertyMapBuilder.toPropertyMap();
        this.autoSchemaReader = new AutoSchemaReader(SchemaReceiverFactory.PROPERTY.get(propertyMap));
    }

    public SchemaFuture installHandlers(XMLReader xMLReader) {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.properties);
        if (this.attributesSchema) {
            NrlProperty.ATTRIBUTES_SCHEMA.add(propertyMapBuilder);
        }
        return new SchemaImpl(propertyMapBuilder.toPropertyMap()).installHandlers(xMLReader, this);
    }

    Schema getNrlSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.nrlSchema == null) {
            String string = SchemaReceiverImpl.class.getName();
            String string2 = string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resources/" + NRL_SCHEMA;
            URL uRL = SchemaReceiverImpl.getResource(string2);
            this.nrlSchema = SAXSchemaReader.getInstance().createSchema(new InputSource(uRL.toString()), this.properties);
        }
        return this.nrlSchema;
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = SchemaReceiverImpl.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    PropertyMap getProperties() {
        return this.properties;
    }

    Schema createChildSchema(InputSource inputSource, String string, PropertyMap propertyMap, boolean bl) throws IOException, IncorrectSchemaException, SAXException {
        SchemaReader schemaReader = SchemaReceiverImpl.isRnc(string) ? CompactSchemaReader.getInstance() : this.autoSchemaReader;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.properties);
        if (bl) {
            NrlProperty.ATTRIBUTES_SCHEMA.add(propertyMapBuilder);
        }
        int n = propertyMap.size();
        for (int i = 0; i < n; ++i) {
            propertyMapBuilder.put(propertyMap.getKey(i), propertyMap.get(propertyMap.getKey(i)));
        }
        return schemaReader.createSchema(inputSource, propertyMapBuilder.toPropertyMap());
    }

    Option getOption(String string) {
        Option option = this.autoSchemaReader.getOption(string);
        if (option != null) {
            return option;
        }
        return CompactSchemaReader.getInstance().getOption(string);
    }

    private static boolean isRnc(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        return string.equals(RNC_MEDIA_TYPE);
    }
}

