/*
 * Decompiled with CFR 0.152.
 */
package com.schematron.ant;

import com.schematron.ant.SchematronResult;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;

public final class Validator {
    private final Templates validator;

    protected Validator(Templates templates) throws IllegalArgumentException {
        if (templates == null) {
            throw new IllegalArgumentException("A validator cannot be constructed with null templates");
        }
        this.validator = templates;
    }

    public SchematronResult validate(Source xml, String fnp, String fdp, String anp, String adp, String encoding) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = this.validator.newTransformer();
        if (encoding != null && encoding.length() > 0) {
            transformer.setOutputProperty("encoding", encoding);
        }
        transformer.setOutputProperty("indent", "yes");
        String sid = xml.getSystemId();
        String aid = "";
        if (sid.startsWith("jar:") || sid.startsWith("zip:")) {
            aid = sid.substring(0, sid.lastIndexOf("!"));
            sid = sid.substring(sid.lastIndexOf("!") + 1);
        }
        if (anp != null && anp.length() > 0) {
            transformer.setParameter("archiveNameParameter", anp);
        } else if (aid != null && aid.length() > 0) {
            transformer.setParameter("archiveNameParameter", aid.substring(aid.lastIndexOf("/") + 1));
        }
        if (adp != null && adp.length() > 0) {
            transformer.setParameter("archiveDirParameter", adp);
        } else if (aid != null && aid.length() > 0 && aid.lastIndexOf("/") > -1) {
            transformer.setParameter("archiveDirParameter", aid.substring(0, aid.lastIndexOf("/")));
        }
        if (fnp != null && fnp.length() > 0) {
            transformer.setParameter("fileNameParameter", fnp);
        } else if (sid != null && sid.length() > 0) {
            transformer.setParameter("fileNameParameter", sid.substring(sid.lastIndexOf("/") + 1));
        }
        if (fdp != null && fdp.length() > 0) {
            transformer.setParameter("fileDirParameter", fdp);
        } else if (sid != null && sid.length() > 0 && sid.lastIndexOf("/") > -1) {
            transformer.setParameter("fileDirParameter", sid.substring(0, sid.lastIndexOf("/")));
        }
        StringWriter writer = new StringWriter();
        transformer.transform(xml, new StreamResult(writer));
        SchematronResult result = new SchematronResult(xml.getSystemId());
        result.setSVRL(writer.toString());
        return result;
    }
}

