/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.auth;

import java.net.InetAddress;
import java.util.Enumeration;
import org.w3c.jigsaw.auth.AuthFilter;
import org.w3c.jigsaw.auth.AuthRealm;
import org.w3c.jigsaw.auth.AuthUser;
import org.w3c.jigsaw.auth.BasicAuthContext;
import org.w3c.jigsaw.auth.BasicAuthContextException;
import org.w3c.jigsaw.auth.IPMatcher;
import org.w3c.jigsaw.auth.RealmsCatalog;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpReplyMessage;

public class GenericAuthFilter
extends AuthFilter {
    protected static int ATTR_ALLOWED_USERS = -1;
    protected static int ATTR_ALLOWED_GROUPS = -1;
    protected IPMatcher ipmatcher = null;
    protected RealmsCatalog catalog = null;
    protected ResourceReference rr_realm = null;
    protected String loaded_realm = null;
    protected HttpChallenge challenge = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void acquireRealm() {
        Object object;
        if (this.catalog == null) {
            object = (httpd)((FramedResource)this.getTargetResource()).getServer();
            this.catalog = ((httpd)object).getRealmsCatalog();
        }
        if ((object = this.getRealm()) == null) {
            return;
        }
        if (this.rr_realm != null && ((String)object).equals(this.loaded_realm)) {
            return;
        }
        this.rr_realm = this.catalog.loadRealm((String)object);
        if (this.rr_realm != null) {
            try {
                AuthRealm authRealm = (AuthRealm)this.rr_realm.lock();
                Enumeration enumeration = authRealm.enumerateUserNames();
                if (enumeration.hasMoreElements()) {
                    this.ipmatcher = new IPMatcher();
                }
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    ResourceReference resourceReference = authRealm.loadUser(string);
                    try {
                        AuthUser authUser = (AuthUser)resourceReference.lock();
                        short[][] sArray = authUser.getIPTemplates();
                        if (sArray == null) continue;
                        for (int i = 0; i < sArray.length; ++i) {
                            this.ipmatcher.add(sArray[i], resourceReference);
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        System.out.println("Invalid user reference : " + string);
                    }
                    finally {
                        resourceReference.unlock();
                    }
                }
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            finally {
                this.rr_realm.unlock();
            }
        }
    }

    protected synchronized boolean checkRealm() {
        this.acquireRealm();
        return this.ipmatcher != null;
    }

    public String[] getAllowedUsers() {
        return (String[])this.getValue(ATTR_ALLOWED_USERS, null);
    }

    public String[] getAllowedGroups() {
        return (String[])this.getValue(ATTR_ALLOWED_GROUPS, null);
    }

    public synchronized ResourceReference lookupUser(InetAddress inetAddress) {
        if (this.ipmatcher == null) {
            this.acquireRealm();
        }
        return (ResourceReference)this.ipmatcher.lookup(inetAddress.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResourceReference lookupUser(String string) {
        if (this.rr_realm == null) {
            this.acquireRealm();
        }
        try {
            AuthRealm authRealm = (AuthRealm)this.rr_realm.lock();
            ResourceReference resourceReference = authRealm.loadUser(string);
            return resourceReference;
        }
        catch (InvalidResourceException invalidResourceException) {
            ResourceReference resourceReference = null;
            return resourceReference;
        }
        finally {
            this.rr_realm.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceReference checkBasicAuth(BasicAuthContext basicAuthContext) {
        ResourceReference resourceReference = this.lookupUser(basicAuthContext.user);
        if (resourceReference != null) {
            try {
                AuthUser authUser = (AuthUser)resourceReference.lock();
                if (authUser == null) {
                    ResourceReference resourceReference2 = null;
                    return resourceReference2;
                }
                if (!authUser.definesAttribute("password")) {
                    ResourceReference resourceReference3 = resourceReference;
                    return resourceReference3;
                }
                ResourceReference resourceReference4 = authUser.getPassword().equals(basicAuthContext.password) ? resourceReference : null;
                return resourceReference4;
            }
            catch (InvalidResourceException invalidResourceException) {
                ResourceReference resourceReference5 = null;
                return resourceReference5;
            }
            finally {
                resourceReference.unlock();
            }
        }
        return null;
    }

    protected boolean checkUser(AuthUser authUser) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3 = this.getAllowedUsers();
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                if (!stringArray3[i].equals(authUser.getName())) continue;
                return true;
            }
        }
        if ((stringArray2 = this.getAllowedGroups()) != null && (stringArray = authUser.getGroups()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray2[j].equals(stringArray[i])) continue;
                    return true;
                }
            }
        }
        return stringArray3 == null && stringArray2 == null;
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_REALM) {
            this.challenge = HttpFactory.makeChallenge("Basic");
            this.challenge.setAuthParameter("realm", this.getRealm());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(Request request) throws ProtocolException {
        Object object;
        Object object2;
        if (!this.checkRealm()) {
            return;
        }
        Client client = request.getClient();
        if (client == null) {
            return;
        }
        boolean bl = false;
        ResourceReference resourceReference = this.lookupUser(client.getInetAddress());
        if (resourceReference != null) {
            try {
                object2 = (AuthUser)resourceReference.lock();
                if (object2 != null) {
                    bl = true;
                    if (!((AttributeHolder)object2).definesAttribute("password") && this.checkUser((AuthUser)object2)) {
                        request.setState("org.w3c.jigsaw.auth.AuthFilter.user", ((AuthUser)object2).getName());
                        request.setState("org.w3c.jigsaw.auth.AuthFilter.type", "ip");
                        return;
                    }
                }
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            finally {
                resourceReference.unlock();
            }
        }
        if (request.hasAuthorization() && !request.isProxy() || request.isProxy() && request.hasProxyAuthorization()) {
            object2 = null;
            try {
                object2 = new BasicAuthContext(request);
            }
            catch (BasicAuthContextException basicAuthContextException) {
                object2 = null;
            }
            if (object2 != null && (resourceReference = this.checkBasicAuth((BasicAuthContext)object2)) != null) {
                try {
                    boolean bl2;
                    object = (AuthUser)resourceReference.lock();
                    if (object != null && this.checkUser((AuthUser)object) && (!(bl2 = ((AttributeHolder)object).definesAttribute("ipaddress")) || bl)) {
                        request.setState("org.w3c.jigsaw.auth.AuthFilter.user", ((BasicAuthContext)object2).user);
                        request.setState("org.w3c.jigsaw.auth.AuthFilter.type", "Basic");
                        return;
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                finally {
                    resourceReference.unlock();
                }
            }
        }
        object2 = null;
        if (request.isProxy()) {
            object2 = request.makeReply(407);
            ((HttpReplyMessage)object2).setProxyAuthenticate(this.challenge);
        } else {
            object2 = request.makeReply(401);
            ((HttpReplyMessage)object2).setWWWAuthenticate(this.challenge);
        }
        object = new HtmlGenerator("Unauthorized");
        ((HtmlGenerator)object).append("<h1>Unauthorized access</h1><p>You are denied access to this resource.");
        ((Reply)object2).setStream((HtmlGenerator)object);
        throw new HTTPException((Reply)object2);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        if (this.getRealm() != null) {
            this.challenge = HttpFactory.makeChallenge("Basic");
            this.challenge.setAuthParameter("realm", this.getRealm());
        }
    }

    static {
        StringArrayAttribute stringArrayAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.auth.GenericAuthFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringArrayAttribute = new StringArrayAttribute("users", null, 2);
        ATTR_ALLOWED_USERS = AttributeRegistry.registerAttribute(clazz, stringArrayAttribute);
        stringArrayAttribute = new StringArrayAttribute("groups", null, 2);
        ATTR_ALLOWED_GROUPS = AttributeRegistry.registerAttribute(clazz, stringArrayAttribute);
    }
}

