/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.resources.upgrade.Attribute;

public class IntegerArrayAttribute
extends Attribute {
    public String stringify(Object object) {
        if (object == null || !(object instanceof int[])) {
            return null;
        }
        int[] nArray = (int[])object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    public boolean checkValue(Object object) {
        return object instanceof int[];
    }

    public final int getPickleLength(Object object) {
        return ((int[])object).length * 4 + 4;
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        int[] nArray = (int[])object;
        dataOutputStream.writeInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    public IntegerArrayAttribute(String string, String[] stringArray, Integer n) {
        super(string, stringArray, n);
        this.type = "int[]";
    }
}

