/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.EncoderException;
import com.phloc.commons.codec.ICodec;
import com.phloc.commons.codec.LZWDecodeDictionary;
import com.phloc.commons.codec.LZWEncodeDictionary;
import com.phloc.commons.codec.LZWNode;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.io.streams.BitInputStream;
import com.phloc.commons.io.streams.BitOutputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LZWCodec
implements ICodec {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LZWCodec.class);

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] aEncodedBuffer) {
        if (aEncodedBuffer == null) {
            return null;
        }
        BitInputStream aBIS = new BitInputStream(new NonBlockingByteArrayInputStream(aEncodedBuffer), true);
        NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream();
        LZWDecodeDictionary aDict = new LZWDecodeDictionary();
        aDict.reset();
        try {
            int nCode = aDict.readCode(aBIS);
            while (nCode == 256) {
                nCode = aDict.readCode(aBIS);
            }
            if (nCode != 257) {
                byte[] aByteSeq = aDict.getBytes(nCode);
                if (aByteSeq == null) {
                    throw new DecoderException("Failed to resolve initial code " + nCode);
                }
                aBAOS.write(aByteSeq);
                byte[] aPrevByteSeq = aByteSeq;
                while ((nCode = aDict.readCode(aBIS)) != 257) {
                    if (nCode == 256) {
                        aDict.reset();
                        nCode = aDict.readCode(aBIS);
                        if (nCode == 257) break;
                        aByteSeq = aDict.getBytes(nCode);
                        aBAOS.write(aByteSeq);
                        aPrevByteSeq = aByteSeq;
                        continue;
                    }
                    int nNextFreeCode = aDict.getNextFreeCode();
                    if (nCode < nNextFreeCode) {
                        aByteSeq = aDict.getBytes(nCode);
                    } else if (nCode == nNextFreeCode) {
                        aByteSeq = ArrayHelper.getConcatenated(aPrevByteSeq, aPrevByteSeq[0]);
                    } else {
                        throw new DecoderException("Error decoding LZW: unexpected code " + nCode + " while next free code is " + nNextFreeCode);
                    }
                    aBAOS.write(aByteSeq);
                    aDict.addString(ArrayHelper.getConcatenated(aPrevByteSeq, aByteSeq[0]), false);
                    aPrevByteSeq = aByteSeq;
                }
            }
            byte[] byArray = aBAOS.toByteArray();
            return byArray;
        }
        catch (EOFException ex) {
            throw new DecoderException("Unexpected EOF decoding LZW", ex);
        }
        catch (IOException ex) {
            throw new DecoderException("Error decoding LZW", ex);
        }
        finally {
            StreamUtils.close(aBIS);
            StreamUtils.close(aBAOS);
        }
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] aBuffer) {
        if (aBuffer == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream();
        BitOutputStream aBOS = new BitOutputStream(aBAOS, true);
        LZWEncodeDictionary aDict = new LZWEncodeDictionary();
        aDict.reset();
        try {
            aBOS.writeBits(256, aDict.getCodeLength());
            byte[] aByteSeq = new byte[]{};
            for (int nIndex = 0; nIndex < aBuffer.length; ++nIndex) {
                byte nByteToEncode = aBuffer[nIndex];
                aByteSeq = ArrayHelper.getConcatenated(aByteSeq, nByteToEncode);
                aDict.visit(nByteToEncode);
                int nCodeLength = aDict.getCodeLength();
                LZWNode aCurNode = aDict.getNode(aByteSeq);
                if (nIndex + 1 == aBuffer.length) {
                    aBOS.writeBits(aCurNode.getTableIndex(), nCodeLength);
                    break;
                }
                if (aCurNode.getChildNode(aBuffer[nIndex + 1]) == null) {
                    aBOS.writeBits(aCurNode.getTableIndex(), nCodeLength);
                    aByteSeq = new byte[]{};
                }
                if (aDict.getNextFreeCode() != 4095) continue;
                aBOS.writeBits(256, nCodeLength);
                aDict.reset();
                nIndex -= aByteSeq.length;
                aByteSeq = new byte[]{};
            }
            int nCodeLength = aDict.getCodeLength();
            switch (aDict.getNextFreeCode()) {
                case 511: 
                case 1023: 
                case 2047: {
                    s_aLogger.info("EOF char gets a new code length: " + ++nCodeLength);
                    break;
                }
            }
            aBOS.writeBits(257, nCodeLength);
        }
        catch (IOException ex) {
            throw new EncoderException("Error encoding LZW", ex);
        }
        finally {
            StreamUtils.close(aBOS);
        }
        return aBAOS.toByteArray();
    }
}

