/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.UseDirectEqualsAndHashCode;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LRUCache<KEYTYPE, VALUETYPE>
extends LinkedHashMap<KEYTYPE, VALUETYPE>
implements IHasSize {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int m_nMaxSize;

    public LRUCache(@Nonnegative int nMaxSize) {
        super(nMaxSize, 0.75f, true);
        this.m_nMaxSize = nMaxSize;
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnull Map.Entry<KEYTYPE, VALUETYPE> aEldest) {
    }

    @Override
    protected final boolean removeEldestEntry(@Nonnull Map.Entry<KEYTYPE, VALUETYPE> aEldest) {
        if (this.size() <= this.m_nMaxSize) {
            return false;
        }
        this.onRemoveEldestEntry(aEldest);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        LRUCache rhs = (LRUCache)o;
        return EqualsUtils.equals(this.m_nMaxSize, rhs.m_nMaxSize) && ((Object)this.entrySet()).equals(rhs.entrySet());
    }

    @Override
    public int hashCode() {
        HashCodeGenerator aHCG = new HashCodeGenerator(this).append(this.m_nMaxSize);
        for (Map.Entry aEntry : this.entrySet()) {
            aHCG.append(aEntry.getKey()).append(aEntry.getValue());
        }
        return aHCG.getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("maxSize", this.m_nMaxSize).append("map", super.toString()).toString();
    }
}

