/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.exceptions;

import com.phloc.commons.exceptions.ILoggedException;
import com.phloc.commons.exceptions.LoggedException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedRuntimeException
extends RuntimeException
implements ILoggedException {
    public static final boolean DEFAULT_DO_LOG = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger((String)"ROOT");
    private static final String MSG_TEXT = "Runtime exception created.";

    public LoggedRuntimeException() {
        this(true);
    }

    public LoggedRuntimeException(boolean bLog) {
        if (bLog) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedRuntimeException(@Nullable String sMsg) {
        this(true, sMsg);
    }

    public LoggedRuntimeException(boolean bLog, @Nullable String sMsg) {
        super(sMsg);
        if (bLog) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedRuntimeException(@Nullable Throwable t) {
        this(true, t);
    }

    public LoggedRuntimeException(boolean bLog, @Nullable Throwable t) {
        super(t);
        if (bLog) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedRuntimeException(@Nullable String sMsg, @Nullable Throwable t) {
        this(true, sMsg, t);
    }

    public LoggedRuntimeException(boolean bLog, @Nullable String sMsg, @Nullable Throwable t) {
        super(sMsg, t);
        if (bLog) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    @Nonnull
    public static RuntimeException newException(@Nullable Throwable t) {
        if (t instanceof LoggedRuntimeException) {
            return (LoggedRuntimeException)t;
        }
        if (t instanceof LoggedException) {
            return new RuntimeException(t);
        }
        return new LoggedRuntimeException(t);
    }

    @Nonnull
    public static RuntimeException newException(@Nullable String sMsg, @Nullable Throwable t) {
        if (t instanceof LoggedRuntimeException) {
            return (LoggedRuntimeException)t;
        }
        if (t instanceof LoggedException) {
            return new RuntimeException(sMsg, t);
        }
        return new LoggedRuntimeException(sMsg, t);
    }
}

